(*
 * Copyright (C) Citrix Systems Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; version 2.1 only. with the special
 * exception on linking described in file LICENSE.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *)

open Xcp_service
open Common

open Server

let socket_path = ref !Storage_interface.default_path

let options = [
  "use-switch", Arg.Set Xcp_client.use_switch, (fun () -> string_of_bool !Xcp_client.use_switch), "true if we want to use the message switch";
  "socket-path", Arg.Set_string socket_path, (fun () -> !socket_path), "Path of listening socket";
  "queue-name", Arg.Set_string Storage_interface.queue_name, (fun () -> !Storage_interface.queue_name), "Name of queue to listen on";
]

let main () =
  debug "%s version %s starting" name Version.version;
  (* The default queue name: *)
  Storage_interface.queue_name := "org.xen.xcp.storage.libvirt";

  configure ~options ();
  let server = Xcp_service.make ~path:!socket_path
    ~queue_name:!Storage_interface.queue_name
    ~rpc_fn:(fun s -> Server.process () s) () in

  Xcp_service.maybe_daemonize ();

  Xcp_service.serve_forever server

let _ = main ()
