#!/usr/bin/env ruby
# Copyright (c) 2008-2009 Citrix Systems Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 only.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#
# This is not a shipped file.  It generates the file named in outputFilename from
# the resx file

require 'rexml/document'

outputFilename = "XSConsoleLangFriendlyNames.py"

if ARGV.size != 1:
  puts "Usage: #{$0} <filename>"
  puts "Please supply the filename for xenadmin.hg/XenAdmin/XenAPI/autogen-enterprise/FriendlyNames.resx"
  abort
end

header = [
"# coding: UTF-8",
"# Copyright (c) 2008-2009 Citrix Systems Inc.",
"#",
"# This program is free software; you can redistribute it and/or modify",
"# it under the terms of the GNU General Public License as published by",
"# the Free Software Foundation; version 2 only.",
"#",
"# This program is distributed in the hope that it will be useful,",
"# but WITHOUT ANY WARRANTY; without even the implied warranty of",
"# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the",
"# GNU General Public License for more details.",
"#",
"# You should have received a copy of the GNU General Public License along",
"# with this program; if not, write to the Free Software Foundation, Inc.,",
"# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.",
"#",
"# Generated by #{File.basename($0)} #{Time.now}",
"# from #{File.basename(ARGV[0])} last modified #{File.mtime(ARGV[0])}",
"",
"class LangFriendlyNames:",
"  @classmethod",
"  def Translate(cls, inTag):",
"    return cls.friendlyNamesMap.get(inTag, inTag)",
"",
"  friendlyNamesMap = {"
]

footer = [
"  }"
]



friendlyNamesMap = {}

file = File.new(ARGV[0])
doc = REXML::Document.new(file)

doc.elements.each('*/data') do |element|
  friendlyNamesMap[element.attributes['name']] = element.elements['value'].text.to_s.gsub("'") { "\\\'" }
end

file.close()

File.open(outputFilename, 'w') do |file|
  header.each { |line| file.write("#{line}\n") }
  friendlyNamesMap.sort.each { |key, value| file.write("    '#{key}' : '#{value}',\n") }
  footer.each { |line| file.write("#{line}\n") }
end
