# coding: UTF-8
# Copyright (c) 2008-2009 Citrix Systems Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 only.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#
# Generated by GenerateXSConsoleLangErrors.rb Fri Dec 18 14:44:43 +0000 2009
# from FriendlyErrorNames.resx last modified Fri Dec 18 14:42:51 +0000 2009

class LangErrors:
  @classmethod
  def Translate(cls, inTag):
    return cls.errorMap.get(inTag, inTag)

  errorMap = {
    'ACTIVATION_WHILE_NOT_FREE' : 'An activation key can only be applied when the edition is set to \'free\'',
    'AUTH_ALREADY_ENABLED' : 'Host operation cannot be performed with external authentication enabled',
    'AUTH_ENABLE_FAILED' : 'The host failed to enable external authentication',
    'AUTH_IS_DISABLED' : 'External authentication is disabled, unable to resolve subject name',
    'AUTH_SERVICE_ERROR' : 'Error querying the external directory service',
    'AUTH_UNKNOWN_TYPE' : 'Unknown type of external authentication',
    'BACKUP_SCRIPT_FAILED' : 'The backup could not be performed because the backup script failed',
    'BOOTLOADER_FAILED' : 'The bootloader for this VM returned an error -- did the VM installation succeed?  {1}',
    'CANNOT_CONTACT_HOST' : 'Cannot forward messages because the host cannot be contacted.  The host may be switched off or there may be network connectivity problems',
    'CANNOT_CREATE_STATE_FILE' : 'An HA statefile could not be created, perhaps because no SR with the appropriate capability was found',
    'CANNOT_ENABLE_REDO_LOG' : 'Could not enable redo log',
    'CANNOT_EVACUATE_HOST' : 'This host cannot be evacuated',
    'CANNOT_FETCH_PATCH' : 'The requested update could to be obtained from the master',
    'CANNOT_FIND_OEM_BACKUP_PARTITION' : 'The backup partition to stream the update to cannot be found',
    'CANNOT_FIND_PATCH' : 'The requested update could not be found.  This can occur when you designate a new master.  Please upload it again',
    'CANNOT_FIND_STATE_PARTITION' : 'The restore could not be performed because the state partition could not be found',
    'CANNOT_PLUG_VIF' : 'This VM cannot be started, as its network interfaces could not be connected.  One of the NICs is in use elsewhere',
    'CANNOT_RESET_CONTROL_DOMAIN' : 'The power-state of a control domain cannot be reset',
    'CERTIFICATE_ALREADY_EXISTS' : 'A certificate already exists with the specified name',
    'CERTIFICATE_CORRUPT' : 'The specified certificate is corrupt or unreadable',
    'CERTIFICATE_DOES_NOT_EXIST' : 'The specified certificate does not exist',
    'CERTIFICATE_LIBRARY_CORRUPT' : 'The certificate library is corrupt or unreadable',
    'CERTIFICATE_NAME_INVALID' : 'The specified certificate name is invalid',
    'CHANGE_PASSWORD_REJECTED' : 'Change password rejected',
    'CRL_ALREADY_EXISTS' : 'A CRL already exists with the specified name',
    'CRL_CORRUPT' : 'The specified CRL is corrupt or unreadable',
    'CRL_DOES_NOT_EXIST' : 'The specified CRL does not exist',
    'CRL_NAME_INVALID' : 'The specified CRL name is invalid',
    'DB_UNIQUENESS_CONSTRAINT_VIOLATION' : 'You attempted an operation which would have resulted in duplicate keys in the database.  Table: {0}, Field: {1}, Value: {2}',
    'DEFAULT_SR_NOT_FOUND' : 'No default SR found',
    'DEVICE_ALREADY_ATTACHED' : 'The device {0} is already attached to a VM',
    'DEVICE_ALREADY_DETACHED' : 'The device {0} is not currently attached',
    'DEVICE_ALREADY_EXISTS' : 'A device with the name given {0} already exists on the selected VM',
    'DEVICE_ATTACH_TIMEOUT' : 'A timeout happened while attempting to attach a device {1} of type {0} to a VM',
    'DEVICE_DETACH_REJECTED' : 'The VM rejected the attempt to detach the device {1} of type {0}. {2}',
    'DEVICE_DETACH_TIMEOUT' : 'A timeout happened while attempting to detach a device {1} of type {0} from a VM',
    'DEVICE_NOT_ATTACHED' : 'The operation could not be performed because the VBD was not connected to the VM',
    'DOMAIN_BUILDER_ERROR' : 'An internal error generated by the domain builder',
    'DOMAIN_EXISTS' : 'The operation could not be performed because a domain still exists for the specified VM',
    'DUPLICATE_VM' : 'Cannot restore this VM because it would create a duplicate',
    'EVACUATE_NO_OTHER_HOSTS_FOR_MASTER' : 'No other host available to nominate as master.  Please add or enable some other hosts',
    'EVENTS_LOST' : 'Some events have been lost from the queue and cannot be retrieved',
    'FIELD_TYPE_ERROR' : 'One of the fields you supplied was of the wrong type',
    'HANDLE_INVALID' : 'Object has been deleted.{0}:{1}',
    'HA_ABORT_NEW_MASTER' : 'This host cannot accept the proposed new master setting at this time',
    'HA_CONSTRAINT_VIOLATION_NETWORK_NOT_SHARED' : 'This operation cannot be performed because the referenced network is not properly shared. The network must either be entirely virtual or must be physically present via a currently_attached PIF on every host',
    'HA_CONSTRAINT_VIOLATION_SR_NOT_SHARED' : 'This operation cannot be performed because the referenced SR is not properly shared. The SR must both be marked as shared and a currently_attached PBD must exist for each host',
    'HA_FAILED_TO_FORM_LIVESET' : 'HA could not be enabled on the Pool because a liveset could not be formed: check storage and network heartbeat paths',
    'HA_HEARTBEAT_DAEMON_STARTUP_FAILED' : 'The host could not join the liveset because the HA daemon failed to start',
    'HA_HOST_CANNOT_ACCESS_STATEFILE' : 'The host could not join the liveset because the HA daemon could not access the heartbeat disk',
    'HA_HOST_CANNOT_SEE_PEERS' : 'The operation failed because the HA software on the specified host could not see a subset of other hosts. Check your network connectivity',
    'HA_HOST_IS_ARMED' : 'The operation could not be performed while the host is still armed; it must be disarmed first',
    'HA_IS_ENABLED' : 'The operation could not be performed because HA is enabled on the Pool',
    'HA_LOST_STATEFILE' : 'This host lost access to the HA statefile',
    'HA_NOT_ENABLED' : 'The operation could not be performed because HA is not enabled on the Pool',
    'HA_NOT_INSTALLED' : 'The operation could not be performed because the HA software is not installed on this host',
    'HA_NO_PLAN' : 'Cannot find a plan for placement of VMs as there are no other hosts available',
    'HA_OPERATION_WOULD_BREAK_FAILOVER_PLAN' : 'This operation cannot be performed because HA would no longer be guaranteed for this pool.  To perform this operation anyway, you must disable or reconfigure HA',
    'HA_POOL_IS_ENABLED_BUT_HOST_IS_DISABLED' : 'This host cannot join the pool because the pool has HA enabled but this host has HA disabled',
    'HA_SHOULD_BE_FENCED' : 'Host cannot rejoin pool because it should have fenced (it is not in the master\'s partition)',
    'HA_TOO_FEW_HOSTS' : 'HA can only be enabled for 2 hosts or more. Note that 2 hosts requires a pre-configured quorum tiebreak script',
    'HOSTS_NOT_HOMOGENEOUS' : 'The hosts in this pool are not homogeneous. {0}',
    'HOST_BROKEN' : 'This host failed in the middle of an automatic failover operation and needs to retry the failover action',
    'HOST_CANNOT_ATTACH_NETWORK' : 'Host cannot attach network (in the case of NIC bonding, this may be because attaching the network on this host would require other networks [that are currently active] to be taken down)',
    'HOST_CANNOT_ATTACH_NETWORK-SHORT' : 'Cannot attach network',
    'HOST_CANNOT_DESTROY_SELF' : 'This host cannot destroy itself',
    'HOST_CANNOT_READ_METRICS' : 'The metrics of this host could not be read',
    'HOST_DISABLED' : 'The specified host is disabled',
    'HOST_DISABLED-SHORT' : 'Disabled',
    'HOST_DISABLED_UNTIL_REBOOT' : 'The specified host is disabled and cannot be re-enabled until after it has rebooted',
    'HOST_HAS_NO_MANAGEMENT_IP' : 'The host failed to acquire an IP address on its management interface and therefore cannot contact the master',
    'HOST_HAS_RESIDENT_VMS' : 'This host can not be forgotten because there are some user VMs still running',
    'HOST_IN_EMERGENCY_MODE' : 'This host is in emergency mode',
    'HOST_IN_RECOVERY_MODE' : 'The backup could not be performed because the host is in recovery mode',
    'HOST_IN_USE' : 'This operation cannot be completed as the host is in use',
    'HOST_IS_LIVE' : 'This operation cannot be completed as the host is still live',
    'HOST_IS_SLAVE' : 'The host that you are talking to is a slave',
    'HOST_MASTER_CANNOT_TALK_BACK' : 'The master reports that it cannot talk back to the slave on the supplied management IP address',
    'HOST_NAME_INVALID' : 'The host name is invalid',
    'HOST_NOT_DISABLED' : 'This host cannot be enabled as it is not disabled',
    'HOST_NOT_ENOUGH_FREE_MEMORY' : 'Not enough host memory available, please shutdown or suspend some VMs',
    'HOST_NOT_ENOUGH_FREE_MEMORY-SHORT' : 'Not enough free memory',
    'HOST_NOT_IN_RECOVERY_MODE' : 'The restore could not be performed because the host is not in recovery mode',
    'HOST_NOT_LIVE' : 'This operation cannot be completed as the host is not live',
    'HOST_NOT_LIVE-SHORT' : 'Unreachable',
    'HOST_OFFLINE' : 'Host could not be contacted',
    'HOST_STILL_BOOTING' : 'XenServer is still booting',
    'HOST_UNKNOWN_TO_MASTER' : 'The master says the host is not known to it. Perhaps the Host was deleted from the master\'s database?',
    'IMPORT_ERROR' : 'This file could not be imported',
    'IMPORT_ERROR_ATTACHED_DISKS_NOT_FOUND' : 'The VM could not be imported because attached disks could not be found',
    'IMPORT_ERROR_CANNOT_HANDLE_CHUNKED' : 'Cannot import VM using chunked encoding',
    'IMPORT_ERROR_FAILED_TO_FIND_OBJECT' : 'The VM could not be imported because a required object could not be found',
    'IMPORT_ERROR_PREMATURE_EOF' : 'The VM could not be imported; the end of the file was reached prematurely',
    'IMPORT_ERROR_SOME_CHECKSUMS_FAILED' : 'Some data checksums were incorrect; the VM may be corrupt',
    'IMPORT_ERROR_UNEXPECTED_FILE' : 'The VM could not be imported because the XVA file is invalid: an unexpected file was encountered',
    'IMPORT_INCOMPATIBLE_VERSION' : 'Cannot import on this host because it was saved on an incompatible version',
    'INTERFACE_HAS_NO_IP' : 'The specified interface cannot be used because it has no IP address',
    'INTERNAL_ERROR' : 'Internal error: {0}',
    'INVALID_DEVICE' : 'The device name {0} is invalid',
    'INVALID_EDITION' : 'The edition you supplied is invalid. Valid editions are \'free\', \'enterprise\' and \'platinum\'',
    'INVALID_IP_ADDRESS_SPECIFIED' : 'A required parameter contained an invalid IP address',
    'INVALID_PATCH' : 'The uploaded update file is invalid',
    'INVALID_PATCH_WITH_LOG' : 'The uploaded update file is invalid.  See attached log for more details',
    'INVALID_VALUE' : 'The value \'{1}\' is invalid for field \'{0}\'',
    'JOINING_HOST_CANNOT_BE_MASTER_OF_OTHER_HOSTS' : 'The host joining the pool cannot already be a master of another pool',
    'JOINING_HOST_CANNOT_CONTAIN_SHARED_SRS' : 'The host joining the pool cannot contain any shared storage',
    'JOINING_HOST_CANNOT_HAVE_RUNNING_OR_SUSPENDED_VMS' : 'The host joining the pool cannot have any running or suspended VMs',
    'JOINING_HOST_CANNOT_HAVE_RUNNING_VMS' : 'The host joining the pool cannot have any running VMs',
    'JOINING_HOST_CANNOT_HAVE_VMS_WITH_CURRENT_OPERATIONS' : 'Joining host cannot have VMs with any current operations',
    'JOINING_HOST_CONNECTION_FAILED' : 'The connection to the joining host failed',
    'JOINING_HOST_SERVICE_FAILED' : 'There was an error connecting to the host. the service contacted didn\'t reply properly',
    'LICENCE_RESTRICTION' : 'This operation is not allowed with your current license',
    'LICENSE_CANNOT_DOWNGRADE_WHILE_IN_POOL' : 'Cannot downgrade license while in pool. Please disband the pool first, then downgrade licenses on hosts separately',
    'LICENSE_CHECKOUT_ERROR' : 'The license for the edition you requested is not available',
    'LICENSE_DOES_NOT_SUPPORT_POOLING' : 'This host cannot join a pool because its license does not support pooling',
    'LICENSE_DOES_NOT_SUPPORT_XHA' : 'XHA cannot be enabled because this host\'s license does not allow it',
    'LICENSE_EXPIRED' : 'Your license has expired',
    'LICENSE_FILE_DEPRECATED' : 'This license file is no longer accepted. Please upgrade to the new licensing system',
    'LICENSE_PROCESSING_ERROR' : 'There was an error processing your license.  Please contact your support representative',
    'LOCATION_NOT_UNIQUE' : 'A VDI with the specified location already exists within the SR',
    'MAC_DOES_NOT_EXIST' : 'The MAC address specified doesn\'t exist on this host',
    'MAC_INVALID' : 'The MAC address specified is not valid',
    'MAC_STILL_EXISTS' : 'The MAC address specified still exists on this host',
    'MAP_DUPLICATE_KEY' : 'You tried to add a new value ({2}) to a map, but that key ({0}) is already there.  The current value is {1}',
    'MEM_MAX_ALLOWED' : 'You have reached the maximum amount of memory allowed for this virtual machine',
    'MEM_MAX_ALLOWED_TITLE' : 'Maximum amount of memory allowed',
    'MESSAGE_DEPRECATED' : 'This message has been deprecated',
    'MESSAGE_METHOD_UNKNOWN' : 'You tried to call a method that does not exist.  The method name that you used is {0}',
    'MESSAGE_PARAMETER_COUNT_MISMATCH' : 'You tried to call the method {0} with the incorrect number of parameters {2}.  The method expect {1} parameter(s)',
    'MISSING_CONNECTION_DETAILS' : 'The license-server connection details (address or port) were missing or incomplete',
    'NETWORK_ALREADY_CONNECTED' : 'You tried to create a PIF, but the network {0} you tried to attach it to is already attached to some other PIF {1}, and so the creation failed',
    'NETWORK_CONTAINS_PIF' : 'The network contains active PIFs ({0}) and cannot be deleted',
    'NETWORK_CONTAINS_VIF' : 'The network contains active VIFs ({0}) and cannot be deleted',
    'NOT_ALLOWED_ON_OEM_EDITION' : 'This command is not allowed on the OEM edition',
    'NOT_IMPLEMENTED' : 'The function {0} is not implemented',
    'NOT_IN_EMERGENCY_MODE' : 'This pool is not in emergency mode',
    'NOT_SUPPORTED_DURING_UPGRADE' : 'This operation is not supported during an upgrade',
    'NO_HOSTS_AVAILABLE' : 'There were no hosts available to complete the specified operation',
    'OBJECT_NOLONGER_EXISTS' : 'The specified object no longer exists',
    'ONLY_ALLOWED_ON_OEM_EDITION' : 'This command is only allowed on the OEM edition',
    'OPERATION_BLOCKED' : 'You attempted an operation that was explicitly blocked (see the blocked_operations field of the given object)',
    'OPERATION_NOT_ALLOWED' : 'You attempted an operation that was not allowed. {0}',
    'OTHER_OPERATION_IN_PROGRESS' : 'Another operation involving the object is currently in progress',
    'OUT_OF_SPACE' : 'There is not enough space to upload the update',
    'PATCH_ALREADY_APPLIED' : 'The update {0} has already been applied',
    'PATCH_ALREADY_EXISTS' : 'The uploaded update already exists',
    'PATCH_APPLY_FAILED' : 'The update failed to apply.  View output for more details',
    'PATCH_IS_APPLIED' : 'The specified patch is applied and cannot be destroyed',
    'PATCH_PRECHECK_FAILED_PREREQUISITE_MISSING' : 'The update precheck stage failed: prerequisite updates are missing',
    'PATCH_PRECHECK_FAILED_UNKNOWN_ERROR' : 'The update precheck stage failed with an unknown error.  See attached info for more details',
    'PATCH_PRECHECK_FAILED_VM_RUNNING' : 'The update precheck stage failed: there are one or more VMs still running on the server.  All VMs must be suspended before the update can be applied',
    'PATCH_PRECHECK_FAILED_WRONG_SERVER_VERSION' : 'The update precheck stage failed: the server is of an incorrect version',
    'PBD_EXISTS' : 'A PBD already exists connecting the SR to the host',
    'PERMISSION_DENIED' : 'Caller not allowed to perform this operation',
    'PIF_ALREADY_BONDED' : 'You cannot create a bond of an interface which is a member of an existing bond',
    'PIF_BOND_NEEDS_MORE_MEMBERS' : 'A bond must consist of at least two member interfaces',
    'PIF_CANNOT_BOND_CROSS_HOST' : 'You cannot bond interfaces across different hosts',
    'PIF_CONFIGURATION_ERROR' : 'An unknown error occurred while attempting to configure an interface',
    'PIF_DEVICE_NOT_FOUND' : 'The specifed device was not found',
    'PIF_DOES_NOT_ALLOW_UNPLUG' : 'The operation you requested cannot be performed because the specified PIF does not allow unplug',
    'PIF_HAS_NO_NETWORK_CONFIGURATION' : 'PIF has no network configuration',
    'PIF_IS_MANAGEMENT_INTERFACE' : 'PIF is the management interface',
    'PIF_IS_PHYSICAL' : 'You tried to destroy the PIF {0}, but it represents an aspect of the physical host configuration, and so cannot be destroyed. ',
    'PIF_IS_VLAN' : 'You tried to create a VLAN on top of another VLAN - use the underlying physical PIF/bond instead',
    'PIF_VLAN_EXISTS' : 'VLAN tag already in use',
    'PIF_VLAN_STILL_EXISTS' : 'Operation cannot proceed while a VLAN exists on this interface',
    'POOL_AUTH_ALREADY_ENABLED' : 'External authentication in this pool is already enabled for at least one host',
    'POOL_AUTH_DISABLE_FAILED' : 'Some AD machine accounts were not disabled successfully on the AD server. External authentication has been disabled',
    'POOL_AUTH_ENABLE_FAILED' : 'Could not enable external authentication: {1}',
    'POOL_JOINING_EXTERNAL_AUTH_MISMATCH' : 'Cannot join pool whose external authentication configuration is different',
    'POOL_JOINING_HOST_MUST_HAVE_PHYSICAL_MANAGEMENT_NIC' : 'The host joining the pool must have a physical management NIC (i.e. the management NIC must not be on a VLAN or bonded PIF)',
    'POOL_JOINING_HOST_MUST_HAVE_SAME_PRODUCT_VERSION' : 'The host joining the pool must have the same product version as the pool master',
    'PROVISION_FAILED_OUT_OF_SPACE' : 'The provision call failed because it ran out of space',
    'PROVISION_ONLY_ALLOWED_ON_TEMPLATE' : 'The provision call can only be invoked on templates, not regular VMs',
    'REDO_LOG_IS_ENABLED' : 'The operation could not be performed because a redo log is enabled on the Pool',
    'RESTORE_INCOMPATIBLE_VERSION' : 'Cannot restore on this host because it was saved on an incompatible version',
    'RESTORE_SCRIPT_FAILED' : 'The restore could not be performed because the restore script failed. Your XenServer Backup file may be corrupt. See the logs for more information',
    'RESTORE_TARGET_MGMT_IF_NOT_IN_BACKUP' : 'The restore could not be performed because the host\'s current management interface is not in the backup. The interfaces mentioned in the backup are:',
    'RESTORE_TARGET_MISSING_DEVICE' : 'The restore could not be performed because a network interface is missing',
    'ROLE_ALREADY_EXISTS' : 'Role already exists',
    'ROLE_NOT_FOUND' : 'Role cannot be found',
    'SESSION_AUTHENTICATION_FAILED' : 'Could not authenticate session. Check your access credentials and try again',
    'SESSION_INVALID' : 'XenCenter\'s connection to the server has been lost',
    'SESSION_NOT_REGISTERED' : 'This session {0} is not registered to receive events.  You must call event.register before event.next.  The session handle you are using is echoed',
    'SLAVE_REQUIRES_MANAGEMENT_INTERFACE' : 'The management interface on a slave cannot be disabled because the slave would enter emergency mode',
    'SR_ATTACH_FAILED' : 'Attaching this SR failed',
    'SR_BACKEND_FAILURE' : 'The SR backend failed to complete the operation',
    'SR_BACKEND_FAILURE_1' : 'Invalid argument',
    'SR_BACKEND_FAILURE_100' : 'Cannot find volume',
    'SR_BACKEND_FAILURE_101' : 'The request is missing the server path parameter',
    'SR_BACKEND_FAILURE_102' : 'The request is missing the server parameter',
    'SR_BACKEND_FAILURE_103' : 'The server path argument is not valid',
    'SR_BACKEND_FAILURE_104' : 'Unable to open the refcount file',
    'SR_BACKEND_FAILURE_105' : 'Root system device, cannot be used for VM storage',
    'SR_BACKEND_FAILURE_106' : 'The IQN provided is an invalid format',
    'SR_BACKEND_FAILURE_107' : 'The SCSIid parameter is missing or incorrect',
    'SR_BACKEND_FAILURE_108' : 'Unable to detect an NFS service on this target',
    'SR_BACKEND_FAILURE_109' : 'The snapshot chain is too long',
    'SR_BACKEND_FAILURE_110' : 'VDI resize failed',
    'SR_BACKEND_FAILURE_120' : 'Netapp Target parameter missing in Dconf string',
    'SR_BACKEND_FAILURE_121' : 'Netapp Username parameter missing in Dconf string',
    'SR_BACKEND_FAILURE_122' : 'Netapp Password parameter missing in Dconf string',
    'SR_BACKEND_FAILURE_123' : 'Netapp Aggregate parameter missing in Dconf string',
    'SR_BACKEND_FAILURE_124' : 'Failed to connect to Netapp target',
    'SR_BACKEND_FAILURE_125' : 'Authentication credentials incorrect',
    'SR_BACKEND_FAILURE_126' : 'Auth credentials have insufficient access privileges',
    'SR_BACKEND_FAILURE_127' : 'Max number of flexvols reached on target. Unable to allocate requested resource',
    'SR_BACKEND_FAILURE_128' : 'Max number of Snapshots reached on target Volume. Unable to create snapshot',
    'SR_BACKEND_FAILURE_129' : 'Insufficient space, unable to create snapshot',
    'SR_BACKEND_FAILURE_130' : 'Netapp Target version unsupported',
    'SR_BACKEND_FAILURE_131' : 'Unable to retrieve target IQN',
    'SR_BACKEND_FAILURE_132' : 'ISCSI service not running on the Netapp target',
    'SR_BACKEND_FAILURE_133' : 'Failed to enable A-SIS for the SR. Requires valid license on the filer',
    'SR_BACKEND_FAILURE_134' : 'The filer will not support A-SIS on this aggregate. The license is valid however on some filers A-SIS is limited to smaller aggregates, e.g. FAS3020 max supported aggregate is 1TB. See filer support documentation for details on your model. You must either disable A-SIS support, or re-configure your aggregate to the max supported size',
    'SR_BACKEND_FAILURE_135' : 'Failed to acquire an exclusive lock on the LUN',
    'SR_BACKEND_FAILURE_140' : 'DNS lookup failed: the given hostname could not be resolved',
    'SR_BACKEND_FAILURE_141' : 'Unable to connect to ISCSI service on target',
    'SR_BACKEND_FAILURE_142' : 'Incorrect value for iSCSI port, must be a number between 1 and 65535',
    'SR_BACKEND_FAILURE_143' : 'Failed to parse the request',
    'SR_BACKEND_FAILURE_144' : 'VDI could not be found',
    'SR_BACKEND_FAILURE_150' : 'Failed to initialise XMLRPC connection',
    'SR_BACKEND_FAILURE_151' : 'Failed to query Local Control Domain',
    'SR_BACKEND_FAILURE_152' : 'A Failure occurred querying the PBD entries',
    'SR_BACKEND_FAILURE_153' : 'A Failure occurred accessing an API object',
    'SR_BACKEND_FAILURE_16' : 'The specified storage repository is currently in use',
    'SR_BACKEND_FAILURE_160' : 'Equallogic Target parameter missing in Dconf string',
    'SR_BACKEND_FAILURE_161' : 'Equallogic Username parameter missing in Dconf string',
    'SR_BACKEND_FAILURE_162' : 'Equallogic Password parameter missing in Dconf string',
    'SR_BACKEND_FAILURE_163' : 'Equallogic StoragePool parameter missing in Dconf string',
    'SR_BACKEND_FAILURE_164' : 'Failed to connect to Equallogic Array; maximum SSH CLI sessions reached',
    'SR_BACKEND_FAILURE_165' : 'Invalid snap-reserver-percentage value, must be an integer indicating the amount of space, as a percentage of the VDI size, to reserve for snapshots',
    'SR_BACKEND_FAILURE_166' : 'Invalid snap-depletion value, must be one of \'delete-oldest\' or \'volume-offline\'',
    'SR_BACKEND_FAILURE_167' : 'Volume out of space, probably due to insufficient snapshot reserve allocation',
    'SR_BACKEND_FAILURE_168' : 'Cannot create Snapshot of a Snapshot VDI, operation unsupported',
    'SR_BACKEND_FAILURE_169' : 'Failed to connect to Equallogic Array, Permission denied;username/password invalid',
    'SR_BACKEND_FAILURE_170' : 'Equallogic Target version unsupported',
    'SR_BACKEND_FAILURE_171' : 'Unable to logon to Array. Check IP settings',
    'SR_BACKEND_FAILURE_172' : 'Equallogic StoragePool parameter specified in Dconf string is Invalid',
    'SR_BACKEND_FAILURE_173' : 'Equallogic Target parameter specified in Dconf string is Invalid, please specify the correct Group IPaddress',
    'SR_BACKEND_FAILURE_180' : 'Volume Group out of space. The SR is over-provisioned, and out of space. Unable to grow the underlying volume to accomodate the virtual size of the disk',
    'SR_BACKEND_FAILURE_181' : 'Error in Metadata volume operation for SR',
    'SR_BACKEND_FAILURE_19' : 'No such device',
    'SR_BACKEND_FAILURE_2' : 'A bad character was detected in the dconf string',
    'SR_BACKEND_FAILURE_200' : 'General IO error',
    'SR_BACKEND_FAILURE_201' : 'Currently unavailable, try again',
    'SR_BACKEND_FAILURE_202' : 'General backend error',
    'SR_BACKEND_FAILURE_203' : 'An active FIST point was reached that causes the process to exit abnormally',
    'SR_BACKEND_FAILURE_220' : 'The device configuration request is missing the Location parameter',
    'SR_BACKEND_FAILURE_221' : 'ISO name must have .iso extension',
    'SR_BACKEND_FAILURE_222' : 'Unable to mount the directory specified in device configuration request',
    'SR_BACKEND_FAILURE_223' : 'Unable to unmount the directory specified in device configuration request',
    'SR_BACKEND_FAILURE_224' : 'Could not locate the ISO sharename on the target, or the access permissions may be incorrect',
    'SR_BACKEND_FAILURE_225' : 'Incorrect Location string format. String must be in the format SERVER:PATH for NFS targets, or \\SERVER\PATH for CIFS targets',
    'SR_BACKEND_FAILURE_226' : 'Invalid local path',
    'SR_BACKEND_FAILURE_24' : 'The specified VDI is currently in use',
    'SR_BACKEND_FAILURE_37' : 'The request to lock/unlock the storage repository or VDI failed',
    'SR_BACKEND_FAILURE_38' : 'The method you have requested is not currently supported',
    'SR_BACKEND_FAILURE_39' : 'The specified storage repository contains data',
    'SR_BACKEND_FAILURE_40' : 'The specified  storage repository scan failed',
    'SR_BACKEND_FAILURE_400' : 'The CSLG server name or IP address is missing',
    'SR_BACKEND_FAILURE_401' : 'The Storage System ID is missing',
    'SR_BACKEND_FAILURE_402' : 'The Storage Pool ID is missing',
    'SR_BACKEND_FAILURE_41' : 'The storage repository log operation failed',
    'SR_BACKEND_FAILURE_410' : 'The gssi operation to the CSLG server failed',
    'SR_BACKEND_FAILURE_411' : 'The SR loading operation failed',
    'SR_BACKEND_FAILURE_412' : 'An invalid storage protocol was specified',
    'SR_BACKEND_FAILURE_413' : 'Unable to parse XML',
    'SR_BACKEND_FAILURE_414' : 'Failed to probe SR',
    'SR_BACKEND_FAILURE_416' : 'Snapshot/Clone failed',
    'SR_BACKEND_FAILURE_417' : 'Storage assignment failed',
    'SR_BACKEND_FAILURE_418' : 'Storage un-assignment failed',
    'SR_BACKEND_FAILURE_419' : 'Storage allocation failed',
    'SR_BACKEND_FAILURE_42' : 'The specified storage repository already exists',
    'SR_BACKEND_FAILURE_420' : 'Storage deallocation failed',
    'SR_BACKEND_FAILURE_421' : 'HBA Query failed',
    'SR_BACKEND_FAILURE_422' : 'IQN/ISCSI initialisation failed',
    'SR_BACKEND_FAILURE_423' : 'SCSI device scan failed',
    'SR_BACKEND_FAILURE_424' : 'Failed to connect to CSLG',
    'SR_BACKEND_FAILURE_425' : 'The Storage Node ID is missing',
    'SR_BACKEND_FAILURE_426' : 'The VDI failed to be introduced to the database',
    'SR_BACKEND_FAILURE_427' : 'The CSLG software doesn\'t seem to be installed',
    'SR_BACKEND_FAILURE_428' : 'Failed to create mulitple sub-pools from parent pool',
    'SR_BACKEND_FAILURE_429' : 'Current XML definition is newer version',
    'SR_BACKEND_FAILURE_43' : 'The specified VDI already exists',
    'SR_BACKEND_FAILURE_430' : 'Failed to communicate with the multipath daemon',
    'SR_BACKEND_FAILURE_44' : 'The specified storage repository has insufficient space',
    'SR_BACKEND_FAILURE_46' : 'The VDI is not available',
    'SR_BACKEND_FAILURE_47' : 'The storage repository is not available',
    'SR_BACKEND_FAILURE_48' : 'The storage repository you are attempting to access is an unknown type',
    'SR_BACKEND_FAILURE_49' : 'The xml string is malformed',
    'SR_BACKEND_FAILURE_50' : 'There was an error while attempting to create the specified logical volume',
    'SR_BACKEND_FAILURE_51' : 'There was an error while attempting to delete the specified logical volume',
    'SR_BACKEND_FAILURE_52' : 'Logical Volume mount/activate error',
    'SR_BACKEND_FAILURE_53' : 'The attempt to umount/deactivate the specified logical volume failed',
    'SR_BACKEND_FAILURE_54' : 'There was an error while attempting to write to the specified logical volume',
    'SR_BACKEND_FAILURE_55' : 'There was an error while attempting to create a partition on the specified logical volume',
    'SR_BACKEND_FAILURE_56' : 'The partition on the logical volume is currently in use',
    'SR_BACKEND_FAILURE_57' : 'There was an error while attempting to create the filesystem on the specified logical volume',
    'SR_BACKEND_FAILURE_58' : 'There was an error while attempting to make a request from the logical volume. The request must come from the master',
    'SR_BACKEND_FAILURE_59' : 'The attempt to resize the logical volume failed',
    'SR_BACKEND_FAILURE_60' : 'The size specified for the logical volume is invalid',
    'SR_BACKEND_FAILURE_61' : 'There was an error while attempting create the file storage repository',
    'SR_BACKEND_FAILURE_62' : 'There was an error while attempting to remove the directory on the file storage repository',
    'SR_BACKEND_FAILURE_63' : 'There was an error while attempting to delete the file storage repository',
    'SR_BACKEND_FAILURE_64' : 'The attempt to remove the VDI failed',
    'SR_BACKEND_FAILURE_65' : 'The attempt to load the VDI failed',
    'SR_BACKEND_FAILURE_66' : 'The VDI type is invalid',
    'SR_BACKEND_FAILURE_67' : 'Unable to add the iSCSI device',
    'SR_BACKEND_FAILURE_68' : 'Logging in to the iSCSI target failed. Check your username and password',
    'SR_BACKEND_FAILURE_69' : 'Logging out of the ISCSI target failed',
    'SR_BACKEND_FAILURE_70' : 'Unable to set the ISCSI initiator',
    'SR_BACKEND_FAILURE_71' : 'The iSCSI daemon failed to start',
    'SR_BACKEND_FAILURE_72' : 'The NFS server version is unsupported',
    'SR_BACKEND_FAILURE_73' : 'There was an error while attempting to mount the NFS share',
    'SR_BACKEND_FAILURE_74' : 'There was an error while attempting to unmount the NFS share',
    'SR_BACKEND_FAILURE_75' : 'The NFS share has already been added',
    'SR_BACKEND_FAILURE_76' : 'The attempt to remove the NFS share failed',
    'SR_BACKEND_FAILURE_77' : 'The attempt to create a logical volume group failed',
    'SR_BACKEND_FAILURE_78' : 'The attempt to create a VDI failed',
    'SR_BACKEND_FAILURE_79' : 'The size specified for the VDI is invalid',
    'SR_BACKEND_FAILURE_80' : 'The attempt to mark the VDI as hidden failed',
    'SR_BACKEND_FAILURE_81' : 'The attempt to clone the VDI failed',
    'SR_BACKEND_FAILURE_82' : 'The attempt to snapshot the VDI failed',
    'SR_BACKEND_FAILURE_83' : 'The attempt to discover the iSCSI target/device failed',
    'SR_BACKEND_FAILURE_84' : 'The iScsi target and received IQNs do not match',
    'SR_BACKEND_FAILURE_85' : 'The attempt to detach the iSCSI failed',
    'SR_BACKEND_FAILURE_86' : 'The attempt to query the iSCSi daemon failed',
    'SR_BACKEND_FAILURE_87' : 'Either LUNid or LUNserial value must be provided',
    'SR_BACKEND_FAILURE_88' : 'There was an error while attempting to create the NFS storage repository',
    'SR_BACKEND_FAILURE_89' : 'The request is missing the LUNid parameter',
    'SR_BACKEND_FAILURE_90' : 'The request is missing the device parameter',
    'SR_BACKEND_FAILURE_91' : 'The device is not a valid path',
    'SR_BACKEND_FAILURE_92' : 'The volume cannot be found',
    'SR_BACKEND_FAILURE_93' : 'The pvs utility returns an error',
    'SR_BACKEND_FAILURE_94' : 'The request is missing the location parameter',
    'SR_BACKEND_FAILURE_95' : 'The request is missing the target parameter',
    'SR_BACKEND_FAILURE_96' : 'The request is missing the target IQN parameter',
    'SR_BACKEND_FAILURE_97' : 'The request is missing the host configuration ISCSI IQN parameter',
    'SR_BACKEND_FAILURE_98' : 'The request is missing the LUN serial number',
    'SR_BACKEND_FAILURE_99' : 'Only 1 LUN may be used with shared LVM',
    'SR_DEVICE_IN_USE' : 'The SR operation cannot be performed because a device underlying the SR is in use by the host',
    'SR_FULL' : 'The SR is full. Requested size {0} exceeds the maximum size {1}',
    'SR_HAS_MULTIPLE_PBDS' : 'The SR.shared flag cannot be set to false while the SR remains connected to multiple hosts',
    'SR_HAS_NO_PBDS' : 'The SR has no attached PBDs',
    'SR_HAS_PBD' : 'The SR {0} is still connected to a host via a PBD. It cannot be destroyed',
    'SR_INDESTRUCTIBLE' : 'The SR could not be destroyed, as the \'indestructible\' flag was set on it',
    'SR_NOT_EMPTY' : 'The SR operation cannot be performed because the SR is not empty',
    'SR_NOT_SHARABLE' : 'SR is not sharable',
    'SR_OPERATION_NOT_SUPPORTED' : 'The SR backend does not support the operation (check the SR\'s allowed operations)',
    'SR_REQUIRES_UPGRADE' : 'The operation cannot be performed until the SR has been upgraded',
    'SR_UNKNOWN_DRIVER' : 'The SR could not be connected because the driver {0} was not recognised',
    'SR_UUID_EXISTS' : 'An SR with that uuid already exists',
    'SR_VDI_LOCKING_FAILED' : 'The operation could not proceed because necessary VDIs were already locked at the storage level',
    'SSL_VERIFY_ERROR' : 'The remote system\'s SSL certificate failed to verify against our certificate library',
    'SUBJECT_ALREADY_EXISTS' : 'Subject already exists',
    'SUBJECT_CANNOT_BE_RESOLVED' : 'Subject cannot be resolved by the external directory service',
    'SYSTEM_STATUS_MUST_USE_TAR_ON_OEM' : 'You must use tar output to retrieve system status from an OEM host',
    'SYSTEM_STATUS_RETRIEVAL_FAILED' : 'Retrieving system status from the host failed',
    'TASK_CANCELLED' : 'The request was asynchronously cancelled',
    'TOO_BUSY' : 'The request was rejected because the server is too busy',
    'TOO_MANY_PENDING_TASKS' : 'The request was rejected because there are too many pending tasks on the server',
    'UNKNOWN_BOOTLOADER' : 'The requested bootloader {1} for VM {0} is unknown',
    'USER_IS_NOT_LOCAL_SUPERUSER' : 'Only the local superuser can execute this operation',
    'UUID_INVALID' : 'The uuid you supplied was invalid',
    'VALUE_NOT_SUPPORTED' : 'You attempted to set value {1} for field {0} that is not supported. {2}',
    'VBDS_MAX_ALLOWED' : 'You have reached the maximum number of virtual disks allowed for this virtual machine',
    'VBDS_MAX_ALLOWED_TITLE' : 'Maximum number of virtual disks allowed',
    'VBD_CDS_MUST_BE_READONLY' : 'Read/write CDs are not supported',
    'VBD_IS_EMPTY' : 'VBD {0} - Operation cound not be performed because the drive is empty',
    'VBD_NOT_EMPTY' : 'VBD {0} - Operation could not be performed because the drive is not empty',
    'VBD_NOT_REMOVABLE_MEDIA' : 'VBD {0} - Media could not be ejected because it is not removable',
    'VBD_NOT_UNPLUGGABLE' : 'Drive could not be hot-unplugged because it is not marked as unpluggable',
    'VBD_TRAY_LOCKED' : 'This VM has locked the DVD drive tray, so the disk cannot be ejected',
    'VCPUS_MAX_ALLOWED' : 'You have reached the maximum number of virtual CPUs allowed for this virtual machine',
    'VCPUS_MAX_ALLOWED_TITLE' : 'Maximum number of virtual CPUs allowed',
    'VDI_INCOMPATIBLE_TYPE' : 'This operation cannot be performed because the specified VDI is of an incompatible type (eg: an HA statefile cannot be attached to a guest)',
    'VDI_IN_USE' : 'This operation cannot be performed because this VDI {0} is in use by some other operation - {1}',
    'VDI_IS_A_PHYSICAL_DEVICE' : 'The operation cannot be performed on physical device',
    'VDI_IS_NOT_ISO' : 'This operation can only be performed on CD VDIs (iso files or CDROM drives).  VDI {0} is of type {1}',
    'VDI_LOCATION_MISSING' : 'This operation cannot be performed because the specified VDI could not be found in the specified SR',
    'VDI_MISSING' : 'This operation cannot be performed because the specified VDI could not be found on the storage substrate',
    'VDI_NOT_AVAILABLE' : 'This operation cannot be performed because VDI {0} could not be properly attached to the VM',
    'VDI_NOT_MANAGED' : 'This operation cannot be performed because the system does not manage this VDI',
    'VDI_READONLY' : 'The operation required write access but VDI {0} is read-only',
    'VIFS_MAX_ALLOWED' : 'You have reached the maximum number of virtual network interfaces allowed for this virtual machine',
    'VIFS_MAX_ALLOWED_TITLE' : 'Maximum number of virtual network interfaces allowed',
    'VIF_IN_USE' : 'Network has active VIFs',
    'VLAN_TAG_INVALID' : 'You tried to create a VLAN, but the tag you gave ({0}) was invalid -- it must be between 0 and 4094',
    'VMS_FAILED_TO_COOPERATE' : 'The given VMs failed to release memory when instructed to do so',
    'VM_BAD_POWER_STATE' : 'You attempted an operation on a VM that needed it to be in state \'{1}\' but was in state \'{2}\'',
    'VM_BIOS_STRINGS_ALREADY_SET' : 'The BIOS strings for this VM have already been set and cannot be changed anymore',
    'VM_CANNOT_DELETE_DEFAULT_TEMPLATE' : 'You cannot delete the specified default template',
    'VM_CHECKPOINT_RESUME_FAILED' : 'An error occurred while restoring the memory image of the specified virtual machine',
    'VM_CHECKPOINT_SUSPEND_FAILED' : 'An error occurred while saving the memory image of the specified virtual machine',
    'VM_DUPLICATE_VBD_DEVICE' : 'The specified VM has a duplicate VBD device and cannot be started',
    'VM_FAILED_SHUTDOWN_ACKNOWLEDGMENT' : 'VM didn\'t acknowledge the need to shutdown',
    'VM_HVM_REQUIRED' : 'HVM is required for this operation',
    'VM_HVM_REQUIRED-SHORT' : 'HVM not supported',
    'VM_IS_PROTECTED' : 'This operation cannot be performed because the specified VM is protected by HA',
    'VM_IS_TEMPLATE' : 'The operation attempted is not valid for template VM {0}',
    'VM_MEMORY_SIZE_TOO_LOW' : 'The specified VM has too little memory to be started',
    'VM_MIGRATE_FAILED' : 'VM migration failed: {3}',
    'VM_MISSING_PV_DRIVERS' : 'You attempted an operation on a VM which requires PV drivers to be installed but the drivers were not detected',
    'VM_NOT_RESIDENT_HERE' : 'The specified VM is not currently resident on the specified host',
    'VM_NO_CRASHDUMP_SR' : 'This VM does not have a crashdump SR specified',
    'VM_NO_SUSPEND_SR' : 'This VM does not have a suspend SR specified',
    'VM_NO_VCPUS' : 'You need at least 1 VCPU to start a VM',
    'VM_OLD_PV_DRIVERS' : 'You attempted an operation on a VM which requires a more recent version of the PV drivers. Please upgrade your PV drivers',
    'VM_REQUIRES_NETWORK' : 'This VM needs a network that cannot be seen from that host',
    'VM_REQUIRES_NETWORK-SHORT' : 'Cannot see required network',
    'VM_REQUIRES_SR' : 'This VM needs storage that cannot be seen from that host',
    'VM_REQUIRES_SR-SHORT' : 'Cannot see required storage',
    'VM_REQUIRES_VDI' : 'VM cannot be started because it requires a VDI which cannot be attached',
    'VM_REVERT_FAILED' : 'An error occurred while reverting the specified virtual machine to the specified snapshot',
    'VM_SHUTDOWN_TIMEOUT' : 'The shutdown of this VM timed out',
    'VM_SNAPSHOT_WITH_QUIESCE_FAILED' : 'The quiesced-snapshot operation failed for an unexpected reason',
    'VM_SNAPSHOT_WITH_QUIESCE_NOT_SUPPORTED' : 'The VSS plug-in is not installed on this virtual machine',
    'VM_SNAPSHOT_WITH_QUIESCE_PLUGIN_DEOS_NOT_RESPOND' : 'The VSS plug-in cannot be contacted',
    'VM_SNAPSHOT_WITH_QUIESCE_TIMEOUT' : 'The VSS plug-in has timed out',
    'VM_TOO_MANY_VCPUS' : 'Too many VCPUs to start this VM',
    'VM_UNSAFE_BOOT' : 'You attempted an operation on VM {0} that was judged to be unsafe by the server. This can happen if the VM would run on a CPU that has a potentially incompatable set of feature flags to those the VM requires. If you want to override this warning then use the \'force\' option',
    'WLB_AUTHENTICATION_FAILED' : 'The WLB server rejected our configured authentication details',
    'WLB_CONNECTION_REFUSED' : 'The WLB server refused a connection to XenServer',
    'WLB_CONNECTION_RESET' : 'The connection to the WLB server was reset',
    'WLB_DISABLED' : 'This pool has wlb-enabled set to false',
    'WLB_INTERNAL_ERROR' : 'The WLB server reported an internal error',
    'WLB_MALFORMED_REQUEST' : 'The WLB server rejected XenServer\'s request as malformed',
    'WLB_MALFORMED_RESPONSE' : 'The WLB server said something that XenServer wasn\'t expecting or didn\'t understand',
    'WLB_NOT_INITIALIZED' : 'No WLB connection is configured',
    'WLB_TIMEOUT' : 'The communication with the WLB server timed out',
    'WLB_UNKNOWN_HOST' : 'The configured WLB server name failed to resolve in DNS',
    'WLB_URL_INVALID' : 'The WLB URL is invalid. Ensure it is in format: &lt;ipaddress&gt;:&lt;port&gt;.  The configured/given URL is returned',
    'WLB_XENSERVER_AUTHENTICATION_FAILED' : 'The WLB server reported that XenServer rejected its configured authentication details',
    'WLB_XENSERVER_CONNECTION_REFUSED' : 'The WLB server reported that XenServer refused it a connection (even though we\'re connecting perfectly fine in the other direction)',
    'WLB_XENSERVER_MALFORMED_RESPONSE' : 'The WLB server reported that XenServer said something to it that WLB wasn\'t expecting or didn\'t understand',
    'WLB_XENSERVER_TIMEOUT' : 'The WLB server reported that communication with XenServer timed out',
    'WLB_XENSERVER_UNKNOWN_HOST' : 'The WLB server reported that its configured server name for this XenServer instance failed to resolve in DNS',
    'XAPI_HOOK_FAILED' : '3rd party xapi hook failed',
    'XENAPI_MISSING_PLUGIN' : 'The requested plugin could not be found',
    'XENAPI_PLUGIN_FAILURE' : 'There was a failure communicating with the plugin',
    'XMLRPC_GENERAL_ERROR' : 'An error occurred while performing the XMLRPC request',
    'XMLRPC_UNMARSHAL_FAILURE' : 'The server failed to unmarshal the XMLRPC message; it was expecting one element and received something else',
  }
