# coding: UTF-8
# Copyright (c) 2008-2009 Citrix Systems Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 only.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#
# Generated by GenerateXSConsoleLangFriendlyNames.rb Fri Dec 18 14:44:46 +0000 2009
# from FriendlyNames.resx last modified Fri Dec 18 14:42:51 +0000 2009

class LangFriendlyNames:
  @classmethod
  def Translate(cls, inTag):
    return cls.friendlyNamesMap.get(inTag, inTag)

  friendlyNamesMap = {
    'AD.PropertyKey-subject-account-disabled' : 'Account disabled',
    'AD.PropertyKey-subject-account-expired' : 'Account expired',
    'AD.PropertyKey-subject-account-locked' : 'Account locked',
    'AD.PropertyKey-subject-gecos' : 'Gecos',
    'AD.PropertyKey-subject-name' : 'Name',
    'AD.PropertyKey-subject-password-expired' : 'Password expired',
    'Description-Bond.master' : 'The bonded interface',
    'Description-Bond.other_config' : 'additional configuration',
    'Description-Bond.slaves' : 'The interfaces which are part of this bond',
    'Description-Bond.uuid' : 'unique identifier/object reference',
    'Description-CpuUsage' : 'CPU Usage',
    'Description-DiskRate' : 'Disk I/O',
    'Description-MemoryUsage' : 'Memory Usage',
    'Description-NetworkRate' : 'Network I/O',
    'Description-PBD.SR' : 'the storage repository that the pbd realises',
    'Description-PBD.currently_attached' : 'is the SR currently attached on this host?',
    'Description-PBD.device_config' : 'a config string to string map that is provided to the host\'s SR-backend-driver',
    'Description-PBD.host' : 'physical machine on which the pbd is available',
    'Description-PBD.other_config' : 'additional configuration',
    'Description-PBD.uuid' : 'unique identifier/object reference',
    'Description-PIF.DNS' : 'IP address of DNS servers to use',
    'Description-PIF.IP' : 'IP address',
    'Description-PIF.MAC' : 'ethernet MAC address of physical interface',
    'Description-PIF.MTU' : 'MTU in octets',
    'Description-PIF.VLAN' : 'VLAN tag for all traffic passing through this interface',
    'Description-PIF.VLAN_master_of' : 'indicates wich VLAN this interface receives untagged traffic from',
    'Description-PIF.VLAN_slave_of' : 'indicates which VLANs this interface transmits tagged traffic to',
    'Description-PIF.bond_master_of' : 'indicates this PIF represents the results of a bond',
    'Description-PIF.bond_slave_of' : 'indicates which bond this interface is part of',
    'Description-PIF.currently_attached' : 'true if this interface is online',
    'Description-PIF.device' : 'machine-readable name of the interface (e.g. eth0)',
    'Description-PIF.disallow_unplug' : 'prevent this PIF from being unplugged; set this to notify the management tool-stack that the PIF has a special use and should not be unplugged under any circumstances (e.g. because you\'re running storage traffic over it)',
    'Description-PIF.gateway' : 'IP gateway',
    'Description-PIF.host' : 'physical machine to which this pif is connected',
    'Description-PIF.ip_configuration_mode' : 'Sets if and how this interface gets an IP address',
    'Description-PIF.management' : 'indicates whether the control software is listening for connections on this interface',
    'Description-PIF.metrics' : 'metrics associated with this PIF',
    'Description-PIF.netmask' : 'IP netmask',
    'Description-PIF.network' : 'virtual network to which this pif is connected',
    'Description-PIF.other_config' : 'additional configuration',
    'Description-PIF.physical' : 'true if this represents a physical network interface',
    'Description-PIF.uuid' : 'unique identifier/object reference',
    'Description-PIF_metrics.carrier' : 'Report if the PIF got a carrier or not',
    'Description-PIF_metrics.device_id' : 'Report device ID',
    'Description-PIF_metrics.device_name' : 'Report device name',
    'Description-PIF_metrics.duplex' : 'Full duplex capability of the link (if available)',
    'Description-PIF_metrics.io_read_kbs' : 'Read bandwidth (KiB/s)',
    'Description-PIF_metrics.io_write_kbs' : 'Write bandwidth (KiB/s)',
    'Description-PIF_metrics.last_updated' : 'Time at which this information was last updated',
    'Description-PIF_metrics.other_config' : 'additional configuration',
    'Description-PIF_metrics.pci_bus_path' : 'PCI bus path of the pif (if available)',
    'Description-PIF_metrics.speed' : 'Speed of the link (if available)',
    'Description-PIF_metrics.uuid' : 'unique identifier/object reference',
    'Description-PIF_metrics.vendor_id' : 'Report vendor ID',
    'Description-PIF_metrics.vendor_name' : 'Report vendor name',
    'Description-SM.capabilities' : 'capabilities of the SM plugin',
    'Description-SM.configuration' : 'names and descriptions of device config keys',
    'Description-SM.copyright' : 'Entity which owns the copyright of this plugin',
    'Description-SM.driver_filename' : 'filename of the storage driver',
    'Description-SM.name_description' : 'a notes field containg human-readable description',
    'Description-SM.name_label' : 'a human-readable name',
    'Description-SM.other_config' : 'additional configuration',
    'Description-SM.required_api_version' : 'Minimum SM API version required on the server',
    'Description-SM.type' : 'SR.type',
    'Description-SM.uuid' : 'unique identifier/object reference',
    'Description-SM.vendor' : 'Vendor who created this plugin',
    'Description-SM.version' : 'Version of the plugin',
    'Description-SR.PBDs' : 'physical blockdevices',
    'Description-SR.VDIs' : 'managed virtual disks',
    'Description-SR.allowed_operations' : 'list of the operations allowed in this state',
    'Description-SR.blobs' : 'Binary blobs associated with this SR',
    'Description-SR.content_type' : 'the type of the SR\'s content, if required (e.g. ISOs)',
    'Description-SR.current_operations' : 'Map of task reference to current operation enumeration',
    'Description-SR.name_description' : 'This Storage Repository\'s description, yours to edit',
    'Description-SR.name_label' : 'This Storage Repository\'s name, yours to edit',
    'Description-SR.other_config' : 'additional configuration',
    'Description-SR.physical_size' : 'total physical size of the repository (in bytes)',
    'Description-SR.physical_utilisation' : 'physical space currently utilised on this storage repository (in bytes). Note that for sparse disk formats, physical_utilisation may be less than virtual_allocation',
    'Description-SR.shared' : 'true if this SR is (capable of being) shared between multiple hosts',
    'Description-SR.sm_config' : 'SM dependent data',
    'Description-SR.tags' : 'user-specified tags for categorization purposes',
    'Description-SR.type' : 'type of the storage repository',
    'Description-SR.uuid' : 'unique identifier/object reference',
    'Description-SR.virtual_allocation' : 'sum of virtual_sizes of all VDIs in this storage repository (in bytes)',
    'Description-VBD.VDI' : 'the virtual disk',
    'Description-VBD.VM' : 'the virtual machine',
    'Description-VBD.allowed_operations' : 'list of the operations allowed in this state',
    'Description-VBD.bootable' : 'true if this VBD is bootable',
    'Description-VBD.current_operations' : 'Map of task reference to current operation enumeration',
    'Description-VBD.currently_attached' : 'is the device currently attached (erased on reboot)',
    'Description-VBD.device' : 'device seen by the guest e.g. hda1',
    'Description-VBD.empty' : 'if true this represents an empty drive',
    'Description-VBD.metrics' : 'metrics associated with this VBD',
    'Description-VBD.mode' : 'the mode the VBD should be mounted with',
    'Description-VBD.other_config' : 'additional configuration',
    'Description-VBD.qos_algorithm_params' : 'parameters for chosen QoS algorithm',
    'Description-VBD.qos_algorithm_type' : 'QoS algorithm to use',
    'Description-VBD.qos_supported_algorithms' : 'supported QoS algorithms for this VBD',
    'Description-VBD.runtime_properties' : 'Device runtime properties',
    'Description-VBD.status_code' : 'error/success code associated with last attach-operation (erased on reboot)',
    'Description-VBD.status_detail' : 'error/success information associated with last attach-operation status (erased on reboot)',
    'Description-VBD.storage_lock' : 'true if a storage level lock was acquired',
    'Description-VBD.type' : 'how the VBD will appear to the guest (e.g. disk or CD)',
    'Description-VBD.unpluggable' : 'true if this VBD will support hot-unplug',
    'Description-VBD.userdevice' : 'user-friendly device name e.g. 0,1,2,etc.',
    'Description-VBD.uuid' : 'unique identifier/object reference',
    'Description-VBD_metrics.io_read_kbs' : 'Read bandwidth (KiB/s)',
    'Description-VBD_metrics.io_write_kbs' : 'Write bandwidth (KiB/s)',
    'Description-VBD_metrics.last_updated' : 'Time at which this information was last updated',
    'Description-VBD_metrics.other_config' : 'additional configuration',
    'Description-VBD_metrics.uuid' : 'unique identifier/object reference',
    'Description-VDI.SR' : 'storage repository in which the VDI resides',
    'Description-VDI.VBDs' : 'list of vbds that refer to this disk',
    'Description-VDI.allowed_operations' : 'list of the operations allowed in this state',
    'Description-VDI.crash_dumps' : 'list of crash dumps that refer to this disk',
    'Description-VDI.current_operations' : 'Map of task reference to current operation enumeration',
    'Description-VDI.is_a_snapshot' : 'true if this is a snapshot.',
    'Description-VDI.location' : 'location information',
    'Description-VDI.managed' : 'disk is managed',
    'Description-VDI.missing' : 'true if SR scan operation reported this VDI as not present on disk',
    'Description-VDI.name_description' : 'This virtual disk\'s description, yours to edit',
    'Description-VDI.name_label' : 'This virtual disk\'s name, yours to edit',
    'Description-VDI.other_config' : 'additional configuration',
    'Description-VDI.parent' : 'References the parent disk, if this VDI is part of a chain',
    'Description-VDI.physical_utilisation' : 'amount of physical space that the disk image is currently taking up on the storage repository (in bytes)',
    'Description-VDI.read_only' : 'true if this disk may ONLY be mounted read-only',
    'Description-VDI.sharable' : 'true if this disk may be shared',
    'Description-VDI.sm_config' : 'SM dependent data',
    'Description-VDI.snapshot_of' : 'Ref pointing to the VDI this snapshot is of.',
    'Description-VDI.snapshot_time' : 'Date/time when this snapshot was created.',
    'Description-VDI.snapshots' : 'List pointing to all the VDIs snapshots.',
    'Description-VDI.storage_lock' : 'true if this disk is locked at the storage level',
    'Description-VDI.tags' : 'user-specified tags for categorization purposes',
    'Description-VDI.type' : 'type of the VDI',
    'Description-VDI.uuid' : 'unique identifier/object reference',
    'Description-VDI.virtual_size' : 'size of disk as presented to the guest (in bytes). Note that, depending on storage backend type, requested size may not be respected exactly',
    'Description-VDI.xenstore_data' : 'data to be inserted into the xenstore tree (/local/domain/0/backend/vbd/<domid>/<device-id>/sm-data) after the VDI is attached. This is generally set by the SM backends on vdi_attach.',
    'Description-VIF.MAC' : 'ethernet MAC address of virtual interface, as exposed to guest',
    'Description-VIF.MAC_autogenerated' : 'true if the MAC was autogenerated; false indicates it was set manually',
    'Description-VIF.MTU' : 'MTU in octets',
    'Description-VIF.VM' : 'virtual machine to which this vif is connected',
    'Description-VIF.allowed_operations' : 'list of the operations allowed in this state',
    'Description-VIF.current_operations' : 'Map of task reference to current operation enumeration',
    'Description-VIF.currently_attached' : 'is the device currently attached (erased on reboot)',
    'Description-VIF.device' : 'name of network device as exposed to guest e.g. eth0',
    'Description-VIF.metrics' : 'metrics associated with this VIF',
    'Description-VIF.network' : 'virtual network to which this vif is connected',
    'Description-VIF.other_config' : 'additional configuration',
    'Description-VIF.qos_algorithm_params' : 'parameters for chosen QoS algorithm',
    'Description-VIF.qos_algorithm_type' : 'QoS algorithm to use',
    'Description-VIF.qos_supported_algorithms' : 'supported QoS algorithms for this VIF',
    'Description-VIF.runtime_properties' : 'Device runtime properties',
    'Description-VIF.status_code' : 'error/success code associated with last attach-operation (erased on reboot)',
    'Description-VIF.status_detail' : 'error/success information associated with last attach-operation status (erased on reboot)',
    'Description-VIF.uuid' : 'unique identifier/object reference',
    'Description-VIF_metrics.io_read_kbs' : 'Read bandwidth (KiB/s)',
    'Description-VIF_metrics.io_write_kbs' : 'Write bandwidth (KiB/s)',
    'Description-VIF_metrics.last_updated' : 'Time at which this information was last updated',
    'Description-VIF_metrics.other_config' : 'additional configuration',
    'Description-VIF_metrics.uuid' : 'unique identifier/object reference',
    'Description-VLAN.other_config' : 'additional configuration',
    'Description-VLAN.tag' : 'VLAN tag in use',
    'Description-VLAN.tagged_PIF' : 'interface on which traffic is tagged',
    'Description-VLAN.untagged_PIF' : 'interface on which traffic is untagged',
    'Description-VLAN.uuid' : 'unique identifier/object reference',
    'Description-VM.HVM_boot_params' : 'HVM boot params',
    'Description-VM.HVM_boot_policy' : 'HVM boot policy',
    'Description-VM.HVM_shadow_multiplier' : 'multiplier applied to the amount of shadow that will be made available to the guest',
    'Description-VM.PCI_bus' : 'PCI bus path for pass-through devices',
    'Description-VM.PV_args' : 'Kernel command-line arguments for this VM (advanced use only)',
    'Description-VM.PV_bootloader' : 'name of or path to bootloader',
    'Description-VM.PV_bootloader_args' : 'miscellaneous arguments for the bootloader',
    'Description-VM.PV_kernel' : 'path to the kernel',
    'Description-VM.PV_legacy_args' : 'to make Zurich guests boot',
    'Description-VM.PV_ramdisk' : 'path to the initrd',
    'Description-VM.VBDs' : 'virtual block devices',
    'Description-VM.VCPUWeight' : 'Virtual CPU Priority',
    'Description-VM.VCPUs' : 'The number of virtual CPUs assigned to the VM',
    'Description-VM.VCPUs_at_startup' : 'Boot number of VCPUs',
    'Description-VM.VCPUs_max' : 'The number of virtual CPUs assigned to the selected VM',
    'Description-VM.VCPUs_params' : 'configuration parameters for the selected VCPU policy',
    'Description-VM.VIFs' : 'virtual network interfaces',
    'Description-VM.VTPMs' : 'virtual TPMs',
    'Description-VM.actions_after_crash' : 'action to take if the guest crashes',
    'Description-VM.actions_after_reboot' : 'action to take after the guest has rebooted itself',
    'Description-VM.actions_after_shutdown' : 'action to take after the guest has shutdown itself',
    'Description-VM.affinity' : 'a host which the VM has some affinity for (or NULL). This is used as a hint to the start call when it decides where to run the VM. Implementations are free to ignore this field.',
    'Description-VM.allowed_operations' : 'list of the VM operations allowed in this state',
    'Description-VM.bios_strings' : 'BIOS strings',
    'Description-VM.blobs' : 'Binary blobs associated with this VM',
    'Description-VM.blocked_operations' : 'List of operations which have been explicitly blocked and an error code',
    'Description-VM.children' : 'List pointing to all the children of this VM',
    'Description-VM.consoles' : 'virtual console devices',
    'Description-VM.crash_dumps' : 'crash dumps associated with this VM',
    'Description-VM.current_operations' : 'Map of task reference to current operation enumeration',
    'Description-VM.domarch' : 'Domain architecture (if available, null string otherwise)',
    'Description-VM.domid' : 'domain ID (if available, -1 otherwise)',
    'Description-VM.guest_metrics' : 'metrics associated with the running guest',
    'Description-VM.ha_always_run' : 'if true then the system will attempt to keep the VM running as much as possible.',
    'Description-VM.ha_restart_priority' : 'Only defined if ha_always_run is set possible values: "best-effort" meaning "try to restart this VM if possible but don\'t consider the Pool to be overcommitted if this is not possible"; and a numerical restart priority (e.g. 1, 2, 3,...)',
    'Description-VM.is_a_snapshot' : 'true if this is a snapshot. Snapshotted VMs can never be started, they are used only for cloning other VMs',
    'Description-VM.is_a_template' : 'true if this is a template. Template VMs can never be started, they are used only for cloning other VMs',
    'Description-VM.is_control_domain' : 'true if this is a control domain (domain 0 or a driver domain)',
    'Description-VM.last_boot_CPU_flags' : 'describes the CPU flags on which the VM was last booted',
    'Description-VM.last_booted_record' : 'marshalled value containing VM record at time of last boot, updated dynamically to reflect the runtime state of the domain',
    'Description-VM.memory_dynamic_max' : 'Dynamic maximum (bytes)',
    'Description-VM.memory_dynamic_min' : 'Dynamic minimum (bytes)',
    'Description-VM.memory_overhead' : 'Virtualization memory overhead (bytes).',
    'Description-VM.memory_static_max' : 'Memory used by this VM',
    'Description-VM.memory_static_min' : 'Statically-set (i.e. absolute) mininum (bytes)',
    'Description-VM.memory_target' : 'Dynamically-set memory target (bytes). The value of this field indicates the current target for memory available to this VM.',
    'Description-VM.metrics' : 'metrics associated with this VM',
    'Description-VM.name_description' : 'This VM\'s description, yours to edit',
    'Description-VM.name_label' : 'This VM\'s name, yours to edit',
    'Description-VM.other_config' : 'additional configuration',
    'Description-VM.parent' : 'Ref pointing to the parent of this VM',
    'Description-VM.platform' : 'platform-specific configuration',
    'Description-VM.power_state' : 'Current power state of the machine',
    'Description-VM.recommendations' : 'An XML specification of recommended values and ranges for properties of this VM',
    'Description-VM.resident_on' : 'the host the VM is currently resident on',
    'Description-VM.snapshot_info' : 'Human-readable information concerning this snapshot',
    'Description-VM.snapshot_metadata' : 'Encoded information about the VM\'s metadata this is a snapshot of',
    'Description-VM.snapshot_of' : 'Ref pointing to the VM this snapshot is of.',
    'Description-VM.snapshot_time' : 'Date/time when this snapshot was created.',
    'Description-VM.snapshots' : 'List pointing to all the VM snapshots.',
    'Description-VM.suspend_VDI' : 'The VDI that a suspend image is stored on. (Only has meaning if VM is currently suspended)',
    'Description-VM.tags' : 'user-specified tags for categorization purposes',
    'Description-VM.transportable_snapshot_id' : 'Transportable ID of the snapshot VM',
    'Description-VM.user_version' : 'a user version number for this machine',
    'Description-VM.uuid' : 'unique identifier/object reference',
    'Description-VM.xenstore_data' : 'data to be inserted into the xenstore tree (/local/domain/<domid>/vm-data) after the VM is created.',
    'Description-VM_guest_metrics.PV_drivers_up_to_date' : 'true if the PV drivers appear to be up to date',
    'Description-VM_guest_metrics.PV_drivers_version' : 'version of the PV drivers',
    'Description-VM_guest_metrics.disks' : 'disk configuration/free space',
    'Description-VM_guest_metrics.last_updated' : 'Time at which this information was last updated',
    'Description-VM_guest_metrics.live' : 'True if the guest is sending heartbeat messages via the guest agent',
    'Description-VM_guest_metrics.memory' : 'free/used/total memory',
    'Description-VM_guest_metrics.networks' : 'network configuration',
    'Description-VM_guest_metrics.os_version' : 'version of the OS',
    'Description-VM_guest_metrics.other' : 'anything else',
    'Description-VM_guest_metrics.other_config' : 'additional configuration',
    'Description-VM_guest_metrics.uuid' : 'unique identifier/object reference',
    'Description-VM_metrics.VCPUs_CPU' : 'VCPU to PCPU map',
    'Description-VM_metrics.VCPUs_flags' : 'CPU flags (blocked,online,running)',
    'Description-VM_metrics.VCPUs_number' : 'Current number of VCPUs',
    'Description-VM_metrics.VCPUs_params' : 'The live equivalent to VM.VCPUs_params',
    'Description-VM_metrics.VCPUs_utilisation' : 'Utilisation for all of guest\'s current VCPUs',
    'Description-VM_metrics.install_time' : 'Time at which the VM was installed',
    'Description-VM_metrics.last_updated' : 'Time at which this information was last updated',
    'Description-VM_metrics.memory_actual' : 'Guest\'s actual memory (bytes)',
    'Description-VM_metrics.other_config' : 'additional configuration',
    'Description-VM_metrics.start_time' : 'Time at which this VM was last booted',
    'Description-VM_metrics.state' : 'The state of the guest, eg blocked, dying etc',
    'Description-VM_metrics.uuid' : 'unique identifier/object reference',
    'Description-VTPM.VM' : 'the virtual machine',
    'Description-VTPM.backend' : 'the domain where the backend is located',
    'Description-VTPM.uuid' : 'unique identifier/object reference',
    'Description-blob.last_updated' : 'Time at which the data in the blob was last updated',
    'Description-blob.mime_type' : 'The mime type associated with this object. Defaults to \'application/octet-stream\' if the empty string is supplied',
    'Description-blob.name_description' : 'a notes field containg human-readable description',
    'Description-blob.name_label' : 'a human-readable name',
    'Description-blob.size' : 'Size of the binary data, in bytes',
    'Description-blob.uuid' : 'unique identifier/object reference',
    'Description-console.VM' : 'VM to which this console is attached',
    'Description-console.location' : 'URI for the console service',
    'Description-console.other_config' : 'additional configuration',
    'Description-console.protocol' : 'the protocol used by this console',
    'Description-console.uuid' : 'unique identifier/object reference',
    'Description-crashdump.VDI' : 'the virtual disk',
    'Description-crashdump.VM' : 'the virtual machine',
    'Description-crashdump.other_config' : 'additional configuration',
    'Description-crashdump.uuid' : 'unique identifier/object reference',
    'Description-data_source.enabled' : 'true if the data source is being logged',
    'Description-data_source.max' : 'the maximum value of the data source',
    'Description-data_source.min' : 'the minimum value of the data source',
    'Description-data_source.name_description' : 'a notes field containg human-readable description',
    'Description-data_source.name_label' : 'a human-readable name',
    'Description-data_source.standard' : 'true if the data source is enabled by default. Non-default data sources cannot be disabled',
    'Description-data_source.units' : 'the units of the value',
    'Description-data_source.value' : 'current value of the data source',
    'Description-event.class' : 'The name of the class of the object that changed',
    'Description-event.id' : 'An ID, monotonically increasing, and local to the current session',
    'Description-event.obj_uuid' : 'The uuid of the object that changed',
    'Description-event.operation' : 'The operation that was performed',
    'Description-event.ref' : 'A reference to the object that changed',
    'Description-event.timestamp' : 'The time at which the event occurred',
    'Description-host.API_version_major' : 'major version number',
    'Description-host.API_version_minor' : 'minor version number',
    'Description-host.API_version_vendor' : 'identification of vendor',
    'Description-host.API_version_vendor_implementation' : 'details of vendor implementation',
    'Description-host.PBDs' : 'physical blockdevices',
    'Description-host.PIFs' : 'physical network interfaces',
    'Description-host.address' : 'The address by which this host can be contacted from any other host in the pool',
    'Description-host.allowed_operations' : 'list of the operations allowed in this state',
    'Description-host.bios_strings' : 'BIOS strings',
    'Description-host.blobs' : 'Binary blobs associated with this host',
    'Description-host.capabilities' : 'Xen capabilities',
    'Description-host.cpu_configuration' : 'The CPU configuration on this host.  May contain keys such as "nr_nodes", "sockets_per_node", "cores_per_socket", or "threads_per_core"',
    'Description-host.crash_dump_sr' : 'The SR in which VDIs for crash dumps are created',
    'Description-host.crashdumps' : 'Set of host crash dumps',
    'Description-host.current_operations' : 'Map of task reference to current operation enumeration',
    'Description-host.edition' : 'XenServer edition',
    'Description-host.enabled' : 'True if the host is currently enabled',
    'Description-host.external_auth_configuration' : 'configuration specific to external authentication service',
    'Description-host.external_auth_service_name' : 'name of external authentication service configured; empty if none configured.',
    'Description-host.external_auth_type' : 'type of external authentication service configured; empty if none configured.',
    'Description-host.ha_network_peers' : 'The set of hosts visible via the network from this host',
    'Description-host.ha_statefiles' : 'The set of statefiles accessible from this host',
    'Description-host.host_CPUs' : 'The physical CPUs on this host',
    'Description-host.hostname' : 'The hostname of this host',
    'Description-host.iscsi_iqn' : 'The host\'s iSCSI IQN',
    'Description-host.license_params' : 'The key/value pairs read from the license file',
    'Description-host.license_server' : 'Contact information of the license server',
    'Description-host.logging' : 'logging configuration',
    'Description-host.memory_overhead' : 'Virtualization memory overhead (bytes).',
    'Description-host.memory_total' : 'Total host memory (bytes)',
    'Description-host.metrics' : 'metrics associated with this host',
    'Description-host.name_description' : 'This host\'s description, yours to edit',
    'Description-host.name_label' : 'This host\'s name, yours to edit',
    'Description-host.other_config' : 'additional configuration',
    'Description-host.patches' : 'Set of host patches',
    'Description-host.power_on_config' : 'The power on config',
    'Description-host.power_on_mode' : 'The power on mode',
    'Description-host.resident_VMs' : 'list of VMs currently resident on host',
    'Description-host.sched_policy' : 'Scheduler policy currently in force on this host',
    'Description-host.software_version' : 'The version details provided by the host',
    'Description-host.supported_bootloaders' : 'a list of the bootloaders installed on the machine',
    'Description-host.suspend_image_sr' : 'The SR in which VDIs for suspend images are created',
    'Description-host.system_status-X11' : 'Log files from the X server',
    'Description-host.system_status-X11-auth' : 'X server authority files',
    'Description-host.system_status-boot-loader' : 'List of boot options and their details given to the user at system boot time',
    'Description-host.system_status-client-logs' : 'Client application log files',
    'Description-host.system_status-disk-info' : 'Partition tables, free space, iSCSI and LVM configuration',
    'Description-host.system_status-firstboot' : 'The scripts run for initializing local storage repositories and networking',
    'Description-host.system_status-hardware-info' : 'Details of the processors, memory and other basic hardware',
    'Description-host.system_status-hdparm-t' : 'Performs a number of timing tests on each local hard disk, these may take up to one minute to complete',
    'Description-host.system_status-high-availability' : 'Log file from the high availability daemon',
    'Description-host.system_status-host-crashdump-dumps' : 'Memory dump created on server crash, if you select this option you will be prompted for these files to be removed after the report has been compiled',
    'Description-host.system_status-host-crashdump-logs' : 'Log files generated at time of server crash',
    'Description-host.system_status-kernel-info' : 'Details of kernel modules, filesystems devices and kernel configuration',
    'Description-host.system_status-loopback-devices' : 'Details of loopback devices',
    'Description-host.system_status-multipath' : 'Retrieves the server\'s storage multipathing configuration',
    'Description-host.system_status-network-config' : 'Configuration files used to bring up network interfaces, provide name resolution and enable the firewall',
    'Description-host.system_status-network-status' : 'Current status of the network interfaces, routing tables and firewall',
    'Description-host.system_status-persistent-stats' : 'Persistent performance statistics',
    'Description-host.system_status-process-list' : 'A complete listing of the processes running in a tree format',
    'Description-host.system_status-system-info' : 'System configuration',
    'Description-host.system_status-system-logs' : 'Logfiles which record the activity of various system processes',
    'Description-host.system_status-system-services' : 'A listing of configured system services',
    'Description-host.system_status-tapdisk-logs' : 'Storage subsystem logs',
    'Description-host.system_status-vncterm' : 'Crash dumps files from the VNCTerm daemon',
    'Description-host.system_status-wlb' : 'Logs and status information from the WLB server monitoring this pool.',
    'Description-host.system_status-xapi-debug' : 'XenServer daemon crash dumps',
    'Description-host.system_status-xapi-subprocess' : 'XenServer daemon process details',
    'Description-host.system_status-xen-info' : 'Details of the hypervisor version and its current state',
    'Description-host.system_status-xenserver-config' : 'Details of the XenServer such as version and build information, primary hard disk location and pool configuration',
    'Description-host.system_status-xenserver-databases' : 'The database which stores the state of the XenServer',
    'Description-host.system_status-xenserver-domains' : 'List of the guest VMs installed onto the server and their current states',
    'Description-host.system_status-xenserver-install' : 'Log files generated during the installation of the XenServer',
    'Description-host.system_status-xenserver-logs' : 'Log files concerning the XenServer\'s activity',
    'Description-host.system_status-xha-liveset' : 'HA liveset',
    'Description-host.system_status-yum' : 'YUM repository information and RPM package database listing',
    'Description-host.tags' : 'user-specified tags for categorization purposes',
    'Description-host.uuid' : 'unique identifier/object reference',
    'Description-host_cpu.family' : 'the family (number) of the physical CPU',
    'Description-host_cpu.features' : 'the physical CPU feature bitmap',
    'Description-host_cpu.flags' : 'the flags of the physical CPU (a decoded version of the features field)',
    'Description-host_cpu.host' : 'the host the CPU is in',
    'Description-host_cpu.model' : 'the model number of the physical CPU',
    'Description-host_cpu.modelname' : 'the model name of the physical CPU',
    'Description-host_cpu.number' : 'the number of the physical CPU within the host',
    'Description-host_cpu.other_config' : 'additional configuration',
    'Description-host_cpu.speed' : 'the speed of the physical CPU',
    'Description-host_cpu.stepping' : 'the stepping of the physical CPU',
    'Description-host_cpu.utilisation' : 'the current CPU utilisation',
    'Description-host_cpu.uuid' : 'unique identifier/object reference',
    'Description-host_cpu.vendor' : 'the vendor of the physical CPU',
    'Description-host_crashdump.host' : 'Host the crashdump relates to',
    'Description-host_crashdump.other_config' : 'additional configuration',
    'Description-host_crashdump.size' : 'Size of the crashdump',
    'Description-host_crashdump.timestamp' : 'Time the crash happened',
    'Description-host_crashdump.uuid' : 'unique identifier/object reference',
    'Description-host_metrics.last_updated' : 'Time at which this information was last updated',
    'Description-host_metrics.live' : 'Pool master thinks this host is live',
    'Description-host_metrics.memory_free' : 'Host\'s free memory (bytes)',
    'Description-host_metrics.memory_total' : 'Host\'s total memory (bytes)',
    'Description-host_metrics.other_config' : 'additional configuration',
    'Description-host_metrics.uuid' : 'unique identifier/object reference',
    'Description-host_patch.applied' : 'True if the patch has been applied',
    'Description-host_patch.host' : 'Host the patch relates to',
    'Description-host_patch.name_description' : 'a notes field containing human-readable description',
    'Description-host_patch.name_label' : 'a human-readable name',
    'Description-host_patch.other_config' : 'additional configuration',
    'Description-host_patch.pool_patch' : 'The patch applied',
    'Description-host_patch.size' : 'Size of the patch',
    'Description-host_patch.timestamp_applied' : 'Time the patch was applied',
    'Description-host_patch.uuid' : 'unique identifier/object reference',
    'Description-host_patch.version' : 'Patch version number',
    'Description-message.body' : 'The body of the message',
    'Description-message.cls' : 'The class of the object this message is associated with',
    'Description-message.name' : 'The name of the message',
    'Description-message.obj_uuid' : 'The uuid of the object this message is associated with',
    'Description-message.priority' : 'The message priority, 0 being low priority',
    'Description-message.timestamp' : 'The time at which the message was created',
    'Description-message.uuid' : 'unique identifier/object reference',
    'Description-network.PIFs' : 'list of connected pifs',
    'Description-network.VIFs' : 'list of connected vifs',
    'Description-network.allowed_operations' : 'list of the operations allowed in this state',
    'Description-network.blobs' : 'Binary blobs associated with this network',
    'Description-network.bridge' : 'name of the bridge corresponding to this network on the local host',
    'Description-network.current_operations' : 'Map of task reference to current operation enumeration',
    'Description-network.name_description' : ' This network\'s description, yours to edit',
    'Description-network.name_label' : 'This network\'s name, yours to edit',
    'Description-network.other_config' : 'additional configuration',
    'Description-network.tags' : 'user-specified tags for categorization purposes',
    'Description-network.uuid' : 'unique identifier/object reference',
    'Description-pool.blobs' : 'Binary blobs associated with this pool',
    'Description-pool.crash_dump_SR' : 'The SR in which VDIs for crash dumps are created',
    'Description-pool.default_SR' : 'Default SR for VDIs',
    'Description-pool.gui_config' : 'gui-specific configuration for pool',
    'Description-pool.ha_allow_overcommit' : 'If set to false then operations which would cause the Pool to become overcommitted will be blocked.',
    'Description-pool.ha_configuration' : 'The current HA configuration',
    'Description-pool.ha_enabled' : 'true if HA is enabled on the pool, false otherwise',
    'Description-pool.ha_host_failures_to_tolerate' : 'Number of host failures to tolerate before the Pool is declared to be overcommitted',
    'Description-pool.ha_overcommitted' : 'True if the Pool is considered to be overcommitted i.e. if there exist insufficient physical resources to tolerate the configured number of host failures',
    'Description-pool.ha_plan_exists_for' : 'Number of future host failures we have managed to find a plan for. Once this reaches zero any future host failures will cause the failure of protected VMs.',
    'Description-pool.ha_statefiles' : 'HA statefile VDIs in use',
    'Description-pool.master' : 'The host that is pool master',
    'Description-pool.name_description' : 'This pool\'s description, yours to edit',
    'Description-pool.name_label' : 'This pool\'s name, yours to edit',
    'Description-pool.other_config' : 'additional configuration',
    'Description-pool.redo_log_enabled' : 'true a redo-log is to be used other than when HA is enabled, false otherwise',
    'Description-pool.redo_log_vdi' : 'indicates the VDI to use for the redo-log other than when HA is enabled',
    'Description-pool.suspend_image_SR' : 'The SR in which VDIs for suspend images are created',
    'Description-pool.tags' : 'user-specified tags for categorization purposes',
    'Description-pool.uuid' : 'unique identifier/object reference',
    'Description-pool.wlb_enabled' : 'true if workload balancing is enabled on the pool, false otherwise',
    'Description-pool.wlb_url' : 'Url for the configured workload balancing host',
    'Description-pool.wlb_username' : 'Username for accessing the workload balancing host',
    'Description-pool.wlb_verify_cert' : 'true if communication with the WLB server should enforce SSL certificate verification.',
    'Description-pool_patch.after_apply_guidance' : 'What the client should do after this patch has been applied.',
    'Description-pool_patch.host_patches' : 'This hosts this patch is applied to.',
    'Description-pool_patch.name_description' : 'a notes field containing human-readable description',
    'Description-pool_patch.name_label' : 'a human-readable name',
    'Description-pool_patch.other_config' : 'additional configuration',
    'Description-pool_patch.pool_applied' : 'This patch should be applied across the entire pool',
    'Description-pool_patch.size' : 'Size of the patch',
    'Description-pool_patch.uuid' : 'unique identifier/object reference',
    'Description-pool_patch.version' : 'Patch version number',
    'Description-role.name_description' : 'what this role is for',
    'Description-role.name_label' : 'a short user-friendly name for the role',
    'Description-role.subroles' : 'a list of pointers to other roles or permissions',
    'Description-role.uuid' : 'unique identifier/object reference',
    'Description-secret.uuid' : 'unique identifier/object reference',
    'Description-secret.value' : 'the secret',
    'Description-session.auth_user_sid' : 'the subject identifier of the user that was externally authenticated. If a session instance has is_local_superuser set, then the value of this field is undefined.',
    'Description-session.is_local_superuser' : 'true iff this session was created using local superuser credentials',
    'Description-session.last_active' : 'Timestamp for last time session was active',
    'Description-session.other_config' : 'additional configuration',
    'Description-session.pool' : 'True if this session relates to a intra-pool login, false otherwise',
    'Description-session.rbac_permissions' : 'list with all RBAC permissions for this session',
    'Description-session.subject' : 'references the subject instance that created the session. If a session instance has is_local_superuser set, then the value of this field is undefined.',
    'Description-session.this_host' : 'Currently connected host',
    'Description-session.this_user' : 'Currently connected user',
    'Description-session.uuid' : 'unique identifier/object reference',
    'Description-session.validation_time' : 'time when session was last validated',
    'Description-subject.other_config' : 'additional configuration',
    'Description-subject.roles' : 'the roles associated with this subject',
    'Description-subject.subject_identifier' : 'the subject identifier, unique in the external directory service',
    'Description-subject.uuid' : 'unique identifier/object reference',
    'Description-task.allowed_operations' : 'Operations allowed on this task',
    'Description-task.created' : 'Time task was created',
    'Description-task.current_operations' : 'Map of task reference to current operation enumeration',
    'Description-task.error_info' : 'if the task has failed, this field contains the set of associated error strings. Undefined otherwise.',
    'Description-task.finished' : 'Time task finished (i.e. succeeded or failed). If task-status is pending, then the value of this field has no meaning',
    'Description-task.name_description' : 'a notes field containg human-readable description',
    'Description-task.name_label' : 'a human-readable name',
    'Description-task.other_config' : 'additional configuration',
    'Description-task.progress' : 'if the task is still pending, this field contains the estimated percentage complete (0-100). If task has completed (successfully or unsuccessfully) this should be 100.',
    'Description-task.resident_on' : 'the host on which the task is running',
    'Description-task.result' : 'if the task has completed successfully, this field contains the result value (either Void or an object reference). Undefined otherwise.',
    'Description-task.status' : 'current status of the task',
    'Description-task.subtask_of' : 'Ref pointing to the task this is a substask of.',
    'Description-task.subtasks' : 'List pointing to all the substasks.',
    'Description-task.type' : 'if the task has completed successfully, this field contains the type of the encoded result (i.e. name of the class whose reference is in the result field). Undefined otherwise.',
    'Description-task.uuid' : 'unique identifier/object reference',
    'Description-user.fullname' : 'full name',
    'Description-user.other_config' : 'additional configuration',
    'Description-user.short_name' : 'short name (e.g. userid)',
    'Description-user.uuid' : 'unique identifier/object reference',
    'Exception-PluginLabelNotDefined' : '\'{0}.label\' has not been defined in the resources file for plugin \'{1}\'.',
    'Exception-PluginOnlyOneCommandPermitted' : 'Only one shell or powershell command permitted.',
    'Exception-PluginResourcesFileNotFound' : 'Could not find resources file for plugin \'{0}\' at \'{1}\'.',
    'Exception-PluginVersionInvalid' : 'Unknown version \'{0}\'.',
    'Exception-PluginXMLNodeNotRecognised' : 'XML node \'{0}\' is not recognised.',
    'Exception-PowerShellExecutionPolicyRestricted' : 'Cannot load the XenServerPSSnapIn if the PowerShell \'ExecutionPolicy\' is equal to \'Restricted\'.',
    'Exception-PowerShellNotPresent' : 'You must have the Powershell installed to use Powershell Plugins. This can be downloaded from the Microsoft website.',
    'Exception-PowerShellSnapInNotPresent' : 'You must have the XenServerPSSnapIn installed to use XenServer PowerShell Commands. This can be found in the SDK.',
    'Exception-SearchParseFailed' : 'Could not parse search \'{0}\' for plugin \'{1}\'.',
    'Exception-XenSearchFileInvalid' : 'The file \'{0}\' is not a valid saved search.',
    'Exception-XmlAttributeMissing' : 'The required attribute \'{0}\' is missing from the \'{1}\' tag.',
    'Exception-XmlInvalid' : 'Failed to parse xml \'{0}\'',
    'Graph-time_axis_label' : 'time',
    'Graph-time_now_label' : 'Now',
    'Graph-time_then_label' : '15 min ago',
    'Label-Action.Action' : 'Action',
    'Label-Action.Alert' : 'Warning',
    'Label-Action.Error' : 'Error',
    'Label-Action.Information' : 'Information',
    'Label-Bond.master' : 'Bond.master',
    'Label-Bond.other_config' : 'Bond.other_config',
    'Label-Bond.slaves' : 'Bond.slaves',
    'Label-Bond.uuid' : 'Bond.uuid',
    'Label-PBD.SR' : 'PBD.SR',
    'Label-PBD.currently_attached' : 'PBD.currently_attached',
    'Label-PBD.device_config' : 'PBD.device_config',
    'Label-PBD.host' : 'PBD.host',
    'Label-PBD.other_config' : 'PBD.other_config',
    'Label-PBD.uuid' : 'PBD.uuid',
    'Label-PIF.DNS' : 'PIF.DNS',
    'Label-PIF.IP' : 'PIF.IP',
    'Label-PIF.MAC' : 'PIF.MAC',
    'Label-PIF.MTU' : 'PIF.MTU',
    'Label-PIF.VLAN' : 'PIF.VLAN',
    'Label-PIF.VLAN_master_of' : 'PIF.VLAN_master_of',
    'Label-PIF.VLAN_slave_of' : 'PIF.VLAN_slave_of',
    'Label-PIF.bond_master_of' : 'PIF.bond_master_of',
    'Label-PIF.bond_slave_of' : 'PIF.bond_slave_of',
    'Label-PIF.currently_attached' : 'PIF.currently_attached',
    'Label-PIF.device' : 'PIF.device',
    'Label-PIF.disallow_unplug' : 'PIF.disallow_unplug',
    'Label-PIF.gateway' : 'PIF.gateway',
    'Label-PIF.host' : 'PIF.host',
    'Label-PIF.ip_configuration_mode' : 'PIF.ip_configuration_mode',
    'Label-PIF.management' : 'PIF.management',
    'Label-PIF.metrics' : 'PIF.metrics',
    'Label-PIF.netmask' : 'PIF.netmask',
    'Label-PIF.network' : 'PIF.network',
    'Label-PIF.other_config' : 'PIF.other_config',
    'Label-PIF.physical' : 'PIF.physical',
    'Label-PIF.uuid' : 'PIF.uuid',
    'Label-PIF_metrics.carrier' : 'PIF_metrics.carrier',
    'Label-PIF_metrics.device_id' : 'PIF_metrics.device_id',
    'Label-PIF_metrics.device_name' : 'PIF_metrics.device_name',
    'Label-PIF_metrics.duplex' : 'PIF_metrics.duplex',
    'Label-PIF_metrics.io_read_kbs' : 'PIF_metrics.io_read_kbs',
    'Label-PIF_metrics.io_write_kbs' : 'PIF_metrics.io_write_kbs',
    'Label-PIF_metrics.last_updated' : 'PIF_metrics.last_updated',
    'Label-PIF_metrics.other_config' : 'PIF_metrics.other_config',
    'Label-PIF_metrics.pci_bus_path' : 'PIF_metrics.pci_bus_path',
    'Label-PIF_metrics.speed' : 'PIF_metrics.speed',
    'Label-PIF_metrics.uuid' : 'PIF_metrics.uuid',
    'Label-PIF_metrics.vendor_id' : 'PIF_metrics.vendor_id',
    'Label-PIF_metrics.vendor_name' : 'PIF_metrics.vendor_name',
    'Label-Pool_patch.applied' : 'Applied',
    'Label-Pool_patch.fully_applied' : 'Fully applied',
    'Label-Pool_patch.not_applied' : 'Not applied',
    'Label-Pool_patch.partially_applied' : 'Partially applied',
    'Label-SM.capabilities' : 'SM.capabilities',
    'Label-SM.configuration' : 'SM.configuration',
    'Label-SM.copyright' : 'SM.copyright',
    'Label-SM.driver_filename' : 'SM.driver_filename',
    'Label-SM.name_description' : 'SM.name_description',
    'Label-SM.name_label' : 'SM.name_label',
    'Label-SM.other_config' : 'SM.other_config',
    'Label-SM.required_api_version' : 'SM.required_api_version',
    'Label-SM.type' : 'SM.type',
    'Label-SM.uuid' : 'SM.uuid',
    'Label-SM.vendor' : 'SM.vendor',
    'Label-SM.version' : 'SM.version',
    'Label-SR.PBDs' : 'SR.PBDs',
    'Label-SR.SRTypes-cslg' : 'Citrix StorageLink Gateway',
    'Label-SR.SRTypes-ebs' : 'Elastic Block Storage',
    'Label-SR.SRTypes-egenera' : 'Egenera Virtual Storage',
    'Label-SR.SRTypes-egeneracd' : 'Egenera Virtual DVD Drive',
    'Label-SR.SRTypes-equal' : 'Dell EqualLogic',
    'Label-SR.SRTypes-ext' : 'Ext3',
    'Label-SR.SRTypes-iso' : 'ISO',
    'Label-SR.SRTypes-local' : 'Local',
    'Label-SR.SRTypes-lvm' : 'LVM',
    'Label-SR.SRTypes-lvmofc' : 'Hardware HBA',
    'Label-SR.SRTypes-lvmohba' : 'Hardware HBA',
    'Label-SR.SRTypes-lvmoiscsi' : 'LVM over iSCSI',
    'Label-SR.SRTypes-netapp' : 'NetApp',
    'Label-SR.SRTypes-nfs' : 'NFS',
    'Label-SR.SRTypes-shm' : 'Local Performance Monitoring',
    'Label-SR.SRTypes-udev' : 'udev',
    'Label-SR.SRTypes-unknown' : 'Unknown',
    'Label-SR.VDIs' : 'SR.VDIs',
    'Label-SR.allowed_operations' : 'SR.allowed_operations',
    'Label-SR.blobs' : 'SR.blobs',
    'Label-SR.content_type' : 'SR.content_type',
    'Label-SR.current_operations' : 'SR.current_operations',
    'Label-SR.name_description' : 'Description',
    'Label-SR.name_label' : 'Name',
    'Label-SR.other_config' : 'SR.other_config',
    'Label-SR.physical_size' : 'SR.physical_size',
    'Label-SR.physical_utilisation' : 'SR.physical_utilisation',
    'Label-SR.scsiid' : 'SCSI ID',
    'Label-SR.shared' : 'SR.shared',
    'Label-SR.size' : 'Size',
    'Label-SR.sm_config' : 'SR.sm_config',
    'Label-SR.state' : 'State',
    'Label-SR.tags' : 'SR.tags',
    'Label-SR.type' : 'SR.type',
    'Label-SR.uuid' : 'SR.uuid',
    'Label-SR.virtual_allocation' : 'SR.virtual_allocation',
    'Label-Template.name_description' : 'Template description',
    'Label-Template.name_label' : 'Template name',
    'Label-VBD.VDI' : 'VBD.VDI',
    'Label-VBD.VM' : 'VBD.VM',
    'Label-VBD.allowed_operations' : 'VBD.allowed_operations',
    'Label-VBD.bootable' : 'VBD.bootable',
    'Label-VBD.current_operations' : 'VBD.current_operations',
    'Label-VBD.currently_attached' : 'VBD.currently_attached',
    'Label-VBD.device' : 'VBD.device',
    'Label-VBD.empty' : 'VBD.empty',
    'Label-VBD.metrics' : 'VBD.metrics',
    'Label-VBD.mode' : 'VBD.mode',
    'Label-VBD.other_config' : 'VBD.other_config',
    'Label-VBD.qos_algorithm_params' : 'VBD.qos_algorithm_params',
    'Label-VBD.qos_algorithm_type' : 'VBD.qos_algorithm_type',
    'Label-VBD.qos_supported_algorithms' : 'VBD.qos_supported_algorithms',
    'Label-VBD.runtime_properties' : 'VBD.runtime_properties',
    'Label-VBD.status_code' : 'VBD.status_code',
    'Label-VBD.status_detail' : 'VBD.status_detail',
    'Label-VBD.storage_lock' : 'VBD.storage_lock',
    'Label-VBD.type' : 'VBD.type',
    'Label-VBD.unpluggable' : 'VBD.unpluggable',
    'Label-VBD.userdevice' : 'VBD.userdevice',
    'Label-VBD.uuid' : 'VBD.uuid',
    'Label-VBD_metrics.io_read_kbs' : 'VBD_metrics.io_read_kbs',
    'Label-VBD_metrics.io_write_kbs' : 'VBD_metrics.io_write_kbs',
    'Label-VBD_metrics.last_updated' : 'VBD_metrics.last_updated',
    'Label-VBD_metrics.other_config' : 'VBD_metrics.other_config',
    'Label-VBD_metrics.uuid' : 'VBD_metrics.uuid',
    'Label-VDI.SR' : 'VDI.SR',
    'Label-VDI.VBDs' : 'VDI.VBDs',
    'Label-VDI.allowed_operations' : 'VDI.allowed_operations',
    'Label-VDI.crash_dumps' : 'VDI.crash_dumps',
    'Label-VDI.current_operations' : 'VDI.current_operations',
    'Label-VDI.is_a_snapshot' : 'VDI.is_a_snapshot',
    'Label-VDI.location' : 'VDI.location',
    'Label-VDI.managed' : 'VDI.managed',
    'Label-VDI.missing' : 'VDI.missing',
    'Label-VDI.name_description' : 'Description',
    'Label-VDI.name_label' : 'Name',
    'Label-VDI.other_config' : 'VDI.other_config',
    'Label-VDI.parent' : 'VDI.parent',
    'Label-VDI.physical_utilisation' : 'VDI.physical_utilisation',
    'Label-VDI.read_only' : 'VDI.read_only',
    'Label-VDI.sharable' : 'VDI.sharable',
    'Label-VDI.sm_config' : 'VDI.sm_config',
    'Label-VDI.snapshot_of' : 'VDI.snapshot_of',
    'Label-VDI.snapshot_time' : 'VDI.snapshot_time',
    'Label-VDI.snapshots' : 'VDI.snapshots',
    'Label-VDI.storage_lock' : 'VDI.storage_lock',
    'Label-VDI.tags' : 'VDI.tags',
    'Label-VDI.type' : 'VDI.type',
    'Label-VDI.uuid' : 'VDI.uuid',
    'Label-VDI.virtual_size' : 'VDI.virtual_size',
    'Label-VDI.xenstore_data' : 'VDI.xenstore_data',
    'Label-VIF.MAC' : 'VIF.MAC',
    'Label-VIF.MAC_autogenerated' : 'VIF.MAC_autogenerated',
    'Label-VIF.MTU' : 'VIF.MTU',
    'Label-VIF.VM' : 'VIF.VM',
    'Label-VIF.allowed_operations' : 'VIF.allowed_operations',
    'Label-VIF.current_operations' : 'VIF.current_operations',
    'Label-VIF.currently_attached' : 'VIF.currently_attached',
    'Label-VIF.device' : 'VIF.device',
    'Label-VIF.metrics' : 'VIF.metrics',
    'Label-VIF.network' : 'VIF.network',
    'Label-VIF.other_config' : 'VIF.other_config',
    'Label-VIF.qos_algorithm_params' : 'VIF.qos_algorithm_params',
    'Label-VIF.qos_algorithm_type' : 'VIF.qos_algorithm_type',
    'Label-VIF.qos_supported_algorithms' : 'VIF.qos_supported_algorithms',
    'Label-VIF.runtime_properties' : 'VIF.runtime_properties',
    'Label-VIF.status_code' : 'VIF.status_code',
    'Label-VIF.status_detail' : 'VIF.status_detail',
    'Label-VIF.uuid' : 'VIF.uuid',
    'Label-VIF_metrics.io_read_kbs' : 'VIF_metrics.io_read_kbs',
    'Label-VIF_metrics.io_write_kbs' : 'VIF_metrics.io_write_kbs',
    'Label-VIF_metrics.last_updated' : 'VIF_metrics.last_updated',
    'Label-VIF_metrics.other_config' : 'VIF_metrics.other_config',
    'Label-VIF_metrics.uuid' : 'VIF_metrics.uuid',
    'Label-VLAN.other_config' : 'VLAN.other_config',
    'Label-VLAN.tag' : 'VLAN.tag',
    'Label-VLAN.tagged_PIF' : 'VLAN.tagged_PIF',
    'Label-VLAN.untagged_PIF' : 'VLAN.untagged_PIF',
    'Label-VLAN.uuid' : 'VLAN.uuid',
    'Label-VM.BootOrder' : 'Boot order',
    'Label-VM.BootOrder-CD' : 'Disk, DVD-ROM',
    'Label-VM.BootOrder-CDN' : 'Disk, DVD-ROM, Network',
    'Label-VM.BootOrder-CND' : 'Disk, Network, DVD-ROM',
    'Label-VM.BootOrder-DC' : 'DVD-ROM, Disk',
    'Label-VM.BootOrder-DCN' : 'DVD-ROM, Disk, Network',
    'Label-VM.BootOrder-DNC' : 'DVD-ROM, Network, Disk',
    'Label-VM.BootOrder-NCD' : 'Network, Disk, DVD-ROM',
    'Label-VM.BootOrder-NDC' : 'Network, DVD-ROM, Disk',
    'Label-VM.BootOrder-Unknown' : 'Unknown',
    'Label-VM.CPUUsage' : 'CPU usage',
    'Label-VM.DiskActivity' : 'Disk activity',
    'Label-VM.HVM_boot_params' : 'VM.HVM_boot_params',
    'Label-VM.HVM_boot_policy' : 'VM.HVM_boot_policy',
    'Label-VM.HVM_shadow_multiplier' : 'VM.HVM_shadow_multiplier',
    'Label-VM.ImageId' : 'Image ID',
    'Label-VM.InstanceId' : 'Instance ID',
    'Label-VM.InstanceType' : 'Instance type',
    'Label-VM.KeyName' : 'Key name',
    'Label-VM.NetworkActivity' : 'Network activity',
    'Label-VM.OSName' : 'Operating System',
    'Label-VM.P2V_ImportDate' : 'P2V Import Date',
    'Label-VM.P2V_SourceMachine' : 'P2V Source Machine',
    'Label-VM.PCI_bus' : 'VM.PCI_bus',
    'Label-VM.PV_args' : 'OS boot parameters',
    'Label-VM.PV_bootloader' : 'VM.PV_bootloader',
    'Label-VM.PV_bootloader_args' : 'VM.PV_bootloader_args',
    'Label-VM.PV_kernel' : 'VM.PV_kernel',
    'Label-VM.PV_legacy_args' : 'VM.PV_legacy_args',
    'Label-VM.PV_ramdisk' : 'VM.PV_ramdisk',
    'Label-VM.PrivateDnsName' : 'Private DNS entry',
    'Label-VM.PublicDnsName' : 'Public DNS entry',
    'Label-VM.UsedMemory' : 'Used memory',
    'Label-VM.VBDs' : 'VM.VBDs',
    'Label-VM.VCPUWeight' : 'VCPU priority',
    'Label-VM.VCPUWeight-0' : 'Lowest',
    'Label-VM.VCPUWeight-1' : 'Very low',
    'Label-VM.VCPUWeight-2' : 'Low',
    'Label-VM.VCPUWeight-3' : 'Below normal',
    'Label-VM.VCPUWeight-4' : 'Normal',
    'Label-VM.VCPUWeight-5' : 'Above normal',
    'Label-VM.VCPUWeight-6' : 'High',
    'Label-VM.VCPUWeight-7' : 'Very high',
    'Label-VM.VCPUWeight-8' : 'Highest',
    'Label-VM.VCPUs' : 'Virtual CPUs',
    'Label-VM.VCPUs_at_startup' : 'VCPUs',
    'Label-VM.VCPUs_max' : 'Virtual CPUs',
    'Label-VM.VCPUs_params' : 'VM.VCPUs_params',
    'Label-VM.VIFs' : 'VM.VIFs',
    'Label-VM.VTPMs' : 'VM.VTPMs',
    'Label-VM.VirtualizationState' : 'Virtualization state',
    'Label-VM.actions_after_crash' : 'VM.actions_after_crash',
    'Label-VM.actions_after_reboot' : 'VM.actions_after_reboot',
    'Label-VM.actions_after_shutdown' : 'VM.actions_after_shutdown',
    'Label-VM.affinity' : 'Home Server',
    'Label-VM.allowed_operations' : 'VM.allowed_operations',
    'Label-VM.auto_boot' : 'Auto-boot',
    'Label-VM.bios_strings' : 'VM.bios_strings',
    'Label-VM.blobs' : 'VM.blobs',
    'Label-VM.blocked_operations' : 'VM.blocked_operations',
    'Label-VM.children' : 'VM.children',
    'Label-VM.consoles' : 'VM.consoles',
    'Label-VM.crash_dumps' : 'VM.crash_dumps',
    'Label-VM.current_operations' : 'VM.current_operations',
    'Label-VM.domarch' : 'VM.domarch',
    'Label-VM.domid' : 'VM.domid',
    'Label-VM.guest_metrics' : 'VM.guest_metrics',
    'Label-VM.ha_always_run' : 'VM.ha_always_run',
    'Label-VM.ha_restart_priority' : 'HA protection level',
    'Label-VM.ha_restart_priority.AlwaysRestart' : 'Protected',
    'Label-VM.ha_restart_priority.BestEffort' : 'Restart if possible',
    'Label-VM.ha_restart_priority.DoNotRestart' : 'Do not restart',
    'Label-VM.ha_restart_priority.High' : 'High',
    'Label-VM.ha_restart_priority.Low' : 'Low',
    'Label-VM.ha_restart_priority.Medium' : 'Medium',
    'Label-VM.is_a_snapshot' : 'VM.is_a_snapshot',
    'Label-VM.is_a_template' : 'VM.is_a_template',
    'Label-VM.is_control_domain' : 'VM.is_control_domain',
    'Label-VM.last_boot_CPU_flags' : 'VM.last_boot_CPU_flags',
    'Label-VM.last_booted_record' : 'VM.last_booted_record',
    'Label-VM.memory_dynamic_max' : 'VM.memory_dynamic_max',
    'Label-VM.memory_dynamic_min' : 'VM.memory_dynamic_min',
    'Label-VM.memory_overhead' : 'VM.memory_overhead',
    'Label-VM.memory_static_max' : 'Memory',
    'Label-VM.memory_static_min' : 'VM.memory_static_min',
    'Label-VM.memory_target' : 'VM.memory_target',
    'Label-VM.metrics' : 'VM.metrics',
    'Label-VM.name_description' : 'VM description',
    'Label-VM.name_label' : 'VM name',
    'Label-VM.other_config' : 'VM.other_config',
    'Label-VM.parent' : 'VM.parent',
    'Label-VM.platform' : 'VM.platform',
    'Label-VM.power_state' : 'VM.power_state',
    'Label-VM.power_state-Halted' : 'Halted',
    'Label-VM.power_state-Paused' : 'Paused',
    'Label-VM.power_state-Running' : 'Running',
    'Label-VM.power_state-Suspended' : 'Suspended',
    'Label-VM.power_state-Unknown' : 'Unknown',
    'Label-VM.recommendations' : 'VM.recommendations',
    'Label-VM.resident_on' : 'VM.resident_on',
    'Label-VM.snapshot_info' : 'VM.snapshot_info',
    'Label-VM.snapshot_metadata' : 'VM.snapshot_metadata',
    'Label-VM.snapshot_of' : 'VM.snapshot_of',
    'Label-VM.snapshot_time' : 'VM.snapshot_time',
    'Label-VM.snapshots' : 'VM.snapshots',
    'Label-VM.suspend_VDI' : 'VM.suspend_VDI',
    'Label-VM.tags' : 'VM.tags',
    'Label-VM.transportable_snapshot_id' : 'VM.transportable_snapshot_id',
    'Label-VM.uptime' : 'Time since startup',
    'Label-VM.user_version' : 'VM.user_version',
    'Label-VM.uuid' : 'VM.uuid',
    'Label-VM.xenstore_data' : 'VM.xenstore_data',
    'Label-VM_guest_metrics.PV_drivers_up_to_date' : 'VM_guest_metrics.PV_drivers_up_to_date',
    'Label-VM_guest_metrics.PV_drivers_version' : 'VM_guest_metrics.PV_drivers_version',
    'Label-VM_guest_metrics.disks' : 'VM_guest_metrics.disks',
    'Label-VM_guest_metrics.last_updated' : 'VM_guest_metrics.last_updated',
    'Label-VM_guest_metrics.live' : 'VM_guest_metrics.live',
    'Label-VM_guest_metrics.memory' : 'VM_guest_metrics.memory',
    'Label-VM_guest_metrics.memory_free' : 'Free',
    'Label-VM_guest_metrics.memory_total' : 'Total',
    'Label-VM_guest_metrics.networks' : 'VM_guest_metrics.networks',
    'Label-VM_guest_metrics.os_version' : 'VM_guest_metrics.os_version',
    'Label-VM_guest_metrics.other' : 'VM_guest_metrics.other',
    'Label-VM_guest_metrics.other_config' : 'VM_guest_metrics.other_config',
    'Label-VM_guest_metrics.uuid' : 'VM_guest_metrics.uuid',
    'Label-VM_metrics.VCPUs_CPU' : 'VM_metrics.VCPUs_CPU',
    'Label-VM_metrics.VCPUs_flags' : 'VM_metrics.VCPUs_flags',
    'Label-VM_metrics.VCPUs_number' : 'VM_metrics.VCPUs_number',
    'Label-VM_metrics.VCPUs_params' : 'VM_metrics.VCPUs_params',
    'Label-VM_metrics.VCPUs_utilisation' : 'VM_metrics.VCPUs_utilisation',
    'Label-VM_metrics.install_time' : 'VM_metrics.install_time',
    'Label-VM_metrics.last_updated' : 'VM_metrics.last_updated',
    'Label-VM_metrics.memory_actual' : 'VM_metrics.memory_actual',
    'Label-VM_metrics.other_config' : 'VM_metrics.other_config',
    'Label-VM_metrics.start_time' : 'VM_metrics.start_time',
    'Label-VM_metrics.state' : 'VM_metrics.state',
    'Label-VM_metrics.uuid' : 'VM_metrics.uuid',
    'Label-VTPM.VM' : 'VTPM.VM',
    'Label-VTPM.backend' : 'VTPM.backend',
    'Label-VTPM.uuid' : 'VTPM.uuid',
    'Label-blob.last_updated' : 'blob.last_updated',
    'Label-blob.mime_type' : 'blob.mime_type',
    'Label-blob.name_description' : 'blob.name_description',
    'Label-blob.name_label' : 'blob.name_label',
    'Label-blob.size' : 'blob.size',
    'Label-blob.uuid' : 'blob.uuid',
    'Label-console.VM' : 'console.VM',
    'Label-console.location' : 'console.location',
    'Label-console.other_config' : 'console.other_config',
    'Label-console.protocol' : 'console.protocol',
    'Label-console.uuid' : 'console.uuid',
    'Label-crashdump.VDI' : 'crashdump.VDI',
    'Label-crashdump.VM' : 'crashdump.VM',
    'Label-crashdump.other_config' : 'crashdump.other_config',
    'Label-crashdump.uuid' : 'crashdump.uuid',
    'Label-data_source.enabled' : 'data_source.enabled',
    'Label-data_source.max' : 'data_source.max',
    'Label-data_source.min' : 'data_source.min',
    'Label-data_source.name_description' : 'data_source.name_description',
    'Label-data_source.name_label' : 'data_source.name_label',
    'Label-data_source.standard' : 'data_source.standard',
    'Label-data_source.units' : 'data_source.units',
    'Label-data_source.value' : 'data_source.value',
    'Label-event.class' : 'event.class',
    'Label-event.id' : 'event.id',
    'Label-event.obj_uuid' : 'event.obj_uuid',
    'Label-event.operation' : 'event.operation',
    'Label-event.ref' : 'event.ref',
    'Label-event.timestamp' : 'event.timestamp',
    'Label-host.API_version_major' : 'host.API_version_major',
    'Label-host.API_version_minor' : 'host.API_version_minor',
    'Label-host.API_version_vendor' : 'host.API_version_vendor',
    'Label-host.API_version_vendor_implementation' : 'host.API_version_vendor_implementation',
    'Label-host.CPUUsage' : 'CPU usage',
    'Label-host.HostCrashdumps' : 'Crashdumps',
    'Label-host.ManagementIP' : 'Management IP',
    'Label-host.NetworkActivity' : 'Network activity',
    'Label-host.PBDs' : 'host.PBDs',
    'Label-host.PIFs' : 'host.PIFs',
    'Label-host.ServerMemory' : 'Server',
    'Label-host.UsedMemory' : 'Used memory',
    'Label-host.VMMemory' : 'VMs',
    'Label-host.XenMemory' : 'Xen',
    'Label-host.address' : 'Address',
    'Label-host.agentUptime' : 'Toolstack uptime',
    'Label-host.allowed_operations' : 'host.allowed_operations',
    'Label-host.bios_strings' : 'host.bios_strings',
    'Label-host.blobs' : 'host.blobs',
    'Label-host.capabilities' : 'host.capabilities',
    'Label-host.cpu_configuration' : 'host.cpu_configuration',
    'Label-host.crash_dump_sr' : 'host.crash_dump_sr',
    'Label-host.crashdumps' : 'host.crashdumps',
    'Label-host.current_operations' : 'host.current_operations',
    'Label-host.edition' : 'Edition',
    'Label-host.edition-enterprise' : 'Citrix Essentials for XenServer, Enterprise Edition',
    'Label-host.edition-free' : 'Citrix XenServer',
    'Label-host.edition-platinum' : 'Citrix Essentials for XenServer, Platinum Edition',
    'Label-host.enabled' : 'Enabled',
    'Label-host.external_auth_configuration' : 'host.external_auth_configuration',
    'Label-host.external_auth_service_name' : 'Domain',
    'Label-host.external_auth_type' : 'host.external_auth_type',
    'Label-host.ha_network_peers' : 'host.ha_network_peers',
    'Label-host.ha_statefiles' : 'host.ha_statefiles',
    'Label-host.host_CPUs' : 'CPUs',
    'Label-host.host_CPUs-Formatter' : 'CPU {0}: {1} {2} GHz',
    'Label-host.hostname' : 'DNS hostname',
    'Label-host.iscsi_iqn' : 'iSCSI IQN',
    'Label-host.license_params' : 'License details',
    'Label-host.license_params-build_number' : 'Build number',
    'Label-host.license_params-date' : 'Release date',
    'Label-host.license_params-expiry' : 'Expiry date',
    'Label-host.license_params-product_brand' : 'Product',
    'Label-host.license_params-product_version' : 'Product version',
    'Label-host.license_params-productcode' : 'Product code',
    'Label-host.license_params-serialnumber' : 'Serial number',
    'Label-host.license_params-sku_type' : 'Server License',
    'Label-host.license_params-sockets' : 'Sockets',
    'Label-host.license_server' : 'host.license_server',
    'Label-host.license_server-address' : 'License Server Address',
    'Label-host.license_server-port' : 'License Server Port',
    'Label-host.log_destination' : 'Log destination',
    'Label-host.logging' : 'host.logging',
    'Label-host.memory_overhead' : 'host.memory_overhead',
    'Label-host.memory_total' : 'host.memory_total',
    'Label-host.metrics' : 'host.metrics',
    'Label-host.name_description' : 'Description',
    'Label-host.name_label' : 'Name',
    'Label-host.other_config' : 'host.other_config',
    'Label-host.patches' : 'host.patches',
    'Label-host.pool_members' : 'Pool members',
    'Label-host.power_on_config' : 'host.power_on_config',
    'Label-host.power_on_mode' : 'host.power_on_mode',
    'Label-host.resident_VMs' : 'host.resident_VMs',
    'Label-host.sched_policy' : 'host.sched_policy',
    'Label-host.sku_type-FG-dell_xe_enterprise' : 'Citrix Essentials for XenServer, Dell Enterprise Edition',
    'Label-host.sku_type-FG-dell_xe_express' : 'Citrix XenServer Dell Edition',
    'Label-host.sku_type-FG-dell_xe_server' : 'Citrix Essentials for XenServer, Dell Enterprise Edition',
    'Label-host.sku_type-FG-hp_xe_enterprise' : 'Citrix Essentials for XenServer, HP Enterprise Edition',
    'Label-host.sku_type-FG-hp_xe_express' : 'Citrix XenServer HP Edition',
    'Label-host.sku_type-FG-hp_xe_server' : 'Citrix Essentials for XenServer, HP Enterprise Edition',
    'Label-host.sku_type-FG-xe_enterprise' : 'Citrix Essentials for XenServer',
    'Label-host.sku_type-FG-xe_express' : 'Citrix XenServer',
    'Label-host.sku_type-FG-xe_server' : 'Citrix Essentials for XenServer',
    'Label-host.sku_type-dell_xe_enterprise' : 'Citrix XenServer Dell Enterprise Edition',
    'Label-host.sku_type-dell_xe_express' : 'Citrix XenServer Dell Express Edition',
    'Label-host.sku_type-dell_xe_server' : 'Citrix XenServer Dell Server Edition',
    'Label-host.sku_type-hp_xe_enterprise' : 'Citrix XenServer HP Enterprise Edition',
    'Label-host.sku_type-hp_xe_express' : 'Citrix XenServer HP Select Edition',
    'Label-host.sku_type-hp_xe_server' : 'Citrix XenServer HP Server Edition',
    'Label-host.sku_type-xe_enterprise' : 'Citrix XenServer Enterprise Edition',
    'Label-host.sku_type-xe_express' : 'Citrix XenServer Express Edition',
    'Label-host.sku_type-xe_server' : 'Citrix XenServer Server Edition',
    'Label-host.software_version' : 'Version details',
    'Label-host.software_version-build_number' : 'XenServer build number',
    'Label-host.software_version-date' : 'XenServer build date',
    'Label-host.software_version-machine-serial-number' : 'Server serial number',
    'Label-host.software_version-oem_build_number' : 'OEM build number',
    'Label-host.software_version-oem_manufacturer' : 'Server manufacturer',
    'Label-host.software_version-oem_model' : 'Server model',
    'Label-host.software_version-product_version' : 'XenServer version',
    'Label-host.supported_bootloaders' : 'host.supported_bootloaders',
    'Label-host.suspend_image_sr' : 'host.suspend_image_sr',
    'Label-host.system_status-CVSM' : 'Citrix StorageLink configuration',
    'Label-host.system_status-X11' : 'X server logs',
    'Label-host.system_status-X11-auth' : 'X11 authority',
    'Label-host.system_status-blobs' : 'User-created binary objects',
    'Label-host.system_status-boot-loader' : 'Boot loader configuration',
    'Label-host.system_status-client-logs' : 'XenCenter logs',
    'Label-host.system_status-disk-info' : 'Disk information',
    'Label-host.system_status-firstboot' : 'First-boot scripts',
    'Label-host.system_status-hardware-info' : 'Hardware information',
    'Label-host.system_status-hdparm-t' : 'Local disk performance test',
    'Label-host.system_status-high-availability' : 'High availability',
    'Label-host.system_status-host-crashdump-dumps' : 'Crash dump files',
    'Label-host.system_status-host-crashdump-logs' : 'Crash dump logs',
    'Label-host.system_status-kernel-info' : 'Kernel information',
    'Label-host.system_status-loopback-devices' : 'Loopback devices',
    'Label-host.system_status-multipath' : 'Multipathing configuration',
    'Label-host.system_status-network-config' : 'Network scripts',
    'Label-host.system_status-network-status' : 'Network status',
    'Label-host.system_status-oem' : 'OEM-specific logs',
    'Label-host.system_status-pam' : 'Authentication module configuration',
    'Label-host.system_status-persistent-stats' : 'Persistent statistics',
    'Label-host.system_status-process-list' : 'Process listing',
    'Label-host.system_status-system-info' : 'System configuration',
    'Label-host.system_status-system-logs' : 'System logs',
    'Label-host.system_status-system-services' : 'System services',
    'Label-host.system_status-tapdisk-logs' : 'Storage subsystem logs',
    'Label-host.system_status-vncterm' : 'VNCTerm crash dumps',
    'Label-host.system_status-wlb' : 'Workload Balancing status',
    'Label-host.system_status-xapi-debug' : 'XenServer daemon crash dumps',
    'Label-host.system_status-xapi-subprocess' : 'XenServer daemon subprocesses',
    'Label-host.system_status-xen-info' : 'Hypervisor configuration',
    'Label-host.system_status-xenserver-config' : 'XenServer configuration',
    'Label-host.system_status-xenserver-databases' : 'XenServer database',
    'Label-host.system_status-xenserver-domains' : 'XenServer domains list',
    'Label-host.system_status-xenserver-install' : 'XenServer installation log files',
    'Label-host.system_status-xenserver-logs' : 'XenServer logs',
    'Label-host.system_status-xha-liveset' : 'High availability liveset',
    'Label-host.system_status-yum' : 'RPM package database',
    'Label-host.tags' : 'host.tags',
    'Label-host.uptime' : 'Server uptime',
    'Label-host.uuid' : 'UUID',
    'Label-host_cpu.family' : 'host_cpu.family',
    'Label-host_cpu.features' : 'host_cpu.features',
    'Label-host_cpu.flags' : 'host_cpu.flags',
    'Label-host_cpu.host' : 'host_cpu.host',
    'Label-host_cpu.model' : 'host_cpu.model',
    'Label-host_cpu.modelname' : 'host_cpu.modelname',
    'Label-host_cpu.number' : 'host_cpu.number',
    'Label-host_cpu.other_config' : 'host_cpu.other_config',
    'Label-host_cpu.speed' : 'host_cpu.speed',
    'Label-host_cpu.stepping' : 'host_cpu.stepping',
    'Label-host_cpu.utilisation' : 'host_cpu.utilisation',
    'Label-host_cpu.uuid' : 'host_cpu.uuid',
    'Label-host_cpu.vendor' : 'host_cpu.vendor',
    'Label-host_crashdump.host' : 'host_crashdump.host',
    'Label-host_crashdump.other_config' : 'host_crashdump.other_config',
    'Label-host_crashdump.size' : 'host_crashdump.size',
    'Label-host_crashdump.timestamp' : 'host_crashdump.timestamp',
    'Label-host_crashdump.uuid' : 'host_crashdump.uuid',
    'Label-host_metrics.last_updated' : 'host_metrics.last_updated',
    'Label-host_metrics.live' : 'host_metrics.live',
    'Label-host_metrics.memory_free' : 'host_metrics.memory_free',
    'Label-host_metrics.memory_total' : 'host_metrics.memory_total',
    'Label-host_metrics.other_config' : 'host_metrics.other_config',
    'Label-host_metrics.uuid' : 'host_metrics.uuid',
    'Label-host_patch.applied' : 'host_patch.applied',
    'Label-host_patch.host' : 'host_patch.host',
    'Label-host_patch.name_description' : 'host_patch.name_description',
    'Label-host_patch.name_label' : 'host_patch.name_label',
    'Label-host_patch.other_config' : 'host_patch.other_config',
    'Label-host_patch.pool_patch' : 'host_patch.pool_patch',
    'Label-host_patch.size' : 'host_patch.size',
    'Label-host_patch.timestamp_applied' : 'host_patch.timestamp_applied',
    'Label-host_patch.uuid' : 'host_patch.uuid',
    'Label-host_patch.version' : 'host_patch.version',
    'Label-message.body' : 'message.body',
    'Label-message.cls' : 'message.cls',
    'Label-message.name' : 'message.name',
    'Label-message.obj_uuid' : 'message.obj_uuid',
    'Label-message.priority' : 'message.priority',
    'Label-message.timestamp' : 'message.timestamp',
    'Label-message.uuid' : 'message.uuid',
    'Label-network.PIFs' : 'network.PIFs',
    'Label-network.VIFs' : 'network.VIFs',
    'Label-network.allowed_operations' : 'network.allowed_operations',
    'Label-network.blobs' : 'network.blobs',
    'Label-network.bridge' : 'network.bridge',
    'Label-network.current_operations' : 'network.current_operations',
    'Label-network.name_description' : 'Description',
    'Label-network.name_label' : 'Name',
    'Label-network.other_config' : 'network.other_config',
    'Label-network.tags' : 'network.tags',
    'Label-network.uuid' : 'network.uuid',
    'Label-performance.avg_cpu' : 'Average CPU',
    'Label-performance.bond_rx' : '{0} Receive',
    'Label-performance.bond_rx_errors' : '{0} Receive Errors',
    'Label-performance.bond_tx' : '{0} Send',
    'Label-performance.bond_tx_errors' : '{0} Send Errors',
    'Label-performance.cpu' : 'CPU {0}',
    'Label-performance.lo_rx' : 'Loopback Receive',
    'Label-performance.lo_rx_errors' : 'Loopback Receive Errors',
    'Label-performance.lo_tx' : 'Loopback Send',
    'Label-performance.lo_tx_errors' : 'Loopback Send Errors',
    'Label-performance.loadavg' : 'Control Domain Load',
    'Label-performance.memory' : 'Total Memory',
    'Label-performance.memory_free_kib' : 'Used Memory',
    'Label-performance.memory_internal_free' : 'Used Memory',
    'Label-performance.memory_internal_used' : 'Used Memory',
    'Label-performance.memory_used_kib' : 'Used Memory',
    'Label-performance.network_latency' : 'Network Latency',
    'Label-performance.nic_rx' : 'NIC {0} Receive',
    'Label-performance.nic_rx_errors' : 'NIC {0} Receive Errors',
    'Label-performance.nic_tx' : 'NIC {0} Send',
    'Label-performance.nic_tx_errors' : 'NIC {0} Send Errors',
    'Label-performance.statefile_latency' : 'HA Statefile Latency',
    'Label-performance.tap_rx' : 'TAP {0} Receive',
    'Label-performance.tap_rx_errors' : 'TAP {0} Receive Errors',
    'Label-performance.tap_tx' : 'TAP {0} Send',
    'Label-performance.tap_tx_errors' : 'TAP {0} Send Errors',
    'Label-performance.vbd_read' : 'Disk {0} Read',
    'Label-performance.vbd_read_latency' : 'Disk {0} Read Latency',
    'Label-performance.vbd_write' : 'Disk {0} Write',
    'Label-performance.vbd_write_latency' : 'Disk {0} Write Latency',
    'Label-performance.vif_rx' : '{0} Receive',
    'Label-performance.vif_rx_errors' : '{0} Receive Errors',
    'Label-performance.vif_tx' : '{0} Send',
    'Label-performance.vif_tx_errors' : '{0} Send Errors',
    'Label-performance.xapi_allocation_kib' : 'Agent Memory Allocation',
    'Label-performance.xapi_free_memory_kib' : 'Agent Memory Free',
    'Label-performance.xapi_latency' : 'XenServer Healthcheck Latency',
    'Label-performance.xapi_live_memory_kib' : 'Agent Memory Live',
    'Label-performance.xapi_memory_usage_kib' : 'Agent Memory Usage',
    'Label-performance.xenbr_rx' : '{0} Receive',
    'Label-performance.xenbr_rx_errors' : '{0} Receive Errors',
    'Label-performance.xenbr_tx' : '{0} Send',
    'Label-performance.xenbr_tx_errors' : '{0} Send Errors',
    'Label-pool.blobs' : 'pool.blobs',
    'Label-pool.crash_dump_SR' : 'pool.crash_dump_SR',
    'Label-pool.default_SR' : 'pool.default_SR',
    'Label-pool.gui_config' : 'pool.gui_config',
    'Label-pool.ha_allow_overcommit' : 'pool.ha_allow_overcommit',
    'Label-pool.ha_configuration' : 'pool.ha_configuration',
    'Label-pool.ha_enabled' : 'Pool HA enabled',
    'Label-pool.ha_host_failures_to_tolerate' : 'Number of server failures to tolerate',
    'Label-pool.ha_overcommitted' : 'pool.ha_overcommitted',
    'Label-pool.ha_plan_exists_for' : 'pool.ha_plan_exists_for',
    'Label-pool.ha_statefiles' : 'pool.ha_statefiles',
    'Label-pool.master' : 'pool.master',
    'Label-pool.name_description' : 'Description',
    'Label-pool.name_label' : 'Name',
    'Label-pool.other_config' : 'pool.other_config',
    'Label-pool.redo_log_enabled' : 'pool.redo_log_enabled',
    'Label-pool.redo_log_vdi' : 'pool.redo_log_vdi',
    'Label-pool.suspend_image_SR' : 'pool.suspend_image_SR',
    'Label-pool.tags' : 'pool.tags',
    'Label-pool.uuid' : 'pool.uuid',
    'Label-pool.wlb_enabled' : 'Pool WLB enabled',
    'Label-pool.wlb_password' : 'pool.wlb_password',
    'Label-pool.wlb_url' : 'Pool WLB Server URL',
    'Label-pool.wlb_username' : 'pool.wlb_username',
    'Label-pool.wlb_verify_cert' : 'pool.wlb_verify_cert',
    'Label-pool_patch.after_apply_guidance' : 'pool_patch.after_apply_guidance',
    'Label-pool_patch.host_patches' : 'pool_patch.host_patches',
    'Label-pool_patch.name_description' : 'pool_patch.name_description',
    'Label-pool_patch.name_label' : 'pool_patch.name_label',
    'Label-pool_patch.other_config' : 'pool_patch.other_config',
    'Label-pool_patch.pool_applied' : 'pool_patch.pool_applied',
    'Label-pool_patch.size' : 'pool_patch.size',
    'Label-pool_patch.uuid' : 'pool_patch.uuid',
    'Label-pool_patch.version' : 'pool_patch.version',
    'Label-role.name_description' : 'role.name_description',
    'Label-role.name_label' : 'role.name_label',
    'Label-role.subroles' : 'role.subroles',
    'Label-role.uuid' : 'role.uuid',
    'Label-secret.uuid' : 'secret.uuid',
    'Label-secret.value' : 'secret.value',
    'Label-session.auth_user_sid' : 'session.auth_user_sid',
    'Label-session.is_local_superuser' : 'session.is_local_superuser',
    'Label-session.last_active' : 'session.last_active',
    'Label-session.other_config' : 'session.other_config',
    'Label-session.pool' : 'session.pool',
    'Label-session.rbac_permissions' : 'session.rbac_permissions',
    'Label-session.subject' : 'session.subject',
    'Label-session.this_host' : 'session.this_host',
    'Label-session.this_user' : 'session.this_user',
    'Label-session.uuid' : 'session.uuid',
    'Label-session.validation_time' : 'session.validation_time',
    'Label-subject.other_config' : 'subject.other_config',
    'Label-subject.roles' : 'subject.roles',
    'Label-subject.subject_identifier' : 'subject.subject_identifier',
    'Label-subject.uuid' : 'subject.uuid',
    'Label-tags' : 'Tags',
    'Label-task.allowed_operations' : 'task.allowed_operations',
    'Label-task.created' : 'task.created',
    'Label-task.current_operations' : 'task.current_operations',
    'Label-task.error_info' : 'task.error_info',
    'Label-task.finished' : 'task.finished',
    'Label-task.name_description' : 'task.name_description',
    'Label-task.name_label' : 'task.name_label',
    'Label-task.other_config' : 'task.other_config',
    'Label-task.progress' : 'task.progress',
    'Label-task.resident_on' : 'task.resident_on',
    'Label-task.result' : 'task.result',
    'Label-task.status' : 'task.status',
    'Label-task.subtask_of' : 'task.subtask_of',
    'Label-task.subtasks' : 'task.subtasks',
    'Label-task.type' : 'task.type',
    'Label-task.uuid' : 'task.uuid',
    'Label-user.fullname' : 'user.fullname',
    'Label-user.other_config' : 'user.other_config',
    'Label-user.short_name' : 'user.short_name',
    'Label-user.uuid' : 'user.uuid',
    'Message.action-ha_heartbeat_approaching_timeout' : 'HA Settings',
    'Message.action-ha_host_failed' : 'HA Settings',
    'Message.action-ha_host_was_fenced' : 'HA Settings',
    'Message.action-ha_network_bonding_error' : 'HA Settings',
    'Message.action-ha_pool_drop_in_plan_exists_for' : 'HA settings',
    'Message.action-ha_pool_overcommitted' : 'HA Settings',
    'Message.action-ha_protected_vm_restart_failed' : 'HA Settings',
    'Message.action-ha_statefile_approaching_timeout' : 'HA Settings',
    'Message.action-ha_statefile_lost' : 'HA Settings',
    'Message.action-ha_xapi_healthcheck_approaching_timeout' : 'HA Settings',
    'Message.action-license_does_not_support_pooling' : 'Buy XenServer Online',
    'Message.action-license_expires_soon' : 'Buy XenServer Online',
    'Message.action-multipath_periodic_alert' : 'View Log Files',
    'Message.action-pbd_plug_failed_on_server_start' : 'Repair Storage',
    'Message.action-vbd_qos_failed' : 'Apply License',
    'Message.action-vcpu_qos_failed' : 'Apply License',
    'Message.action-vif_qos_failed' : 'Apply License',
    'Message.body-alarm' : 'Alarm \'{0}\' was not recognised.',
    'Message.body-extauth_in_pool_is_non_homogeneous' : 'The external authentication service used within \'{0}\' is not consistent.',
    'Message.body-extauth_init_in_host_failed' : 'Server \'{0}\' has failed to connect to the Active Directory server {1}',
    'Message.body-grace_license' : 'A grace license was issued for {0}. This was either because the license server could not be reached or because the host has recently been upgraded.',
    'Message.body-ha_heartbeat_approaching_timeout' : 'Server \'{0}\' is taking too long to respond to the HA networking heartbeat and may fence.',
    'Message.body-ha_host_failed' : 'Server \'{0}\' has failed.',
    'Message.body-ha_host_was_fenced' : 'Server \'{0}\' was fenced, and has now successfully restarted and rejoined the pool.',
    'Message.body-ha_network_bonding_error' : 'One of the paths in network bond \'{0}\' on server \'{1}\' has failed.  HA protection is at risk without it.',
    'Message.body-ha_pool_drop_in_plan_exists_for-0' : 'The failover tolerance for pool \'{0}\' has dropped to 0, and HA is no longer guaranteed.',
    'Message.body-ha_pool_drop_in_plan_exists_for-1' : 'The failover tolerance for pool \'{0}\' has dropped.  HA is now only guaranteed for 1 host failure.',
    'Message.body-ha_pool_drop_in_plan_exists_for-n' : 'The failover tolerance for pool \'{0}\' has dropped.  HA is now only guaranteed for {1} host failures.',
    'Message.body-ha_pool_overcommitted' : 'The maximum number of server failures tolerable in pool \'{0}\' has fallen below the requested value ',
    'Message.body-ha_protected_vm_restart_failed' : 'Virtual machine \'{0}\', which is protected under HA, has failed to start.',
    'Message.body-ha_statefile_approaching_timeout' : 'Server \'{0}\' is taking too long to write to the heartbeat storage and may fence.',
    'Message.body-ha_statefile_lost' : 'The servers in pool \'{0}\' cannot access the heartbeat SR.  HA protection is severely impaired without it.',
    'Message.body-ha_xapi_healthcheck_approaching_timeout' : 'XenServer on server \'{0}\' is taking too long to respond and may fence.',
    'Message.body-host_clock_skew_detected' : 'The clock on server \'{0}\' is not synchronized with the other servers in pool \'{1}\'.  This can lead to errors when migrating virtual machines, and also affect any performance data collected in the future.',
    'Message.body-host_sync_data_failed' : 'There was a temporary failure synchronizing performance statistics across the pool, probably because one or more servers were offline.  Another synchronization attempt will be made later.',
    'Message.body-license_does_not_support_pooling' : 'The license on server \'{0}\' has expired or been changed, and no longer supports XenServer Enterprise features.',
    'Message.body-license_expired' : 'The license for {0} has expired.',
    'Message.body-license_expires_soon' : 'The license on host \'{0}\' will expire at {1}.',
    'Message.body-license_not_available' : 'The license-server did not issue a license for {0} because there were no license of the specified type available.',
    'Message.body-license_server_connected' : 'The server {0} has successfully connected to the license server.',
    'Message.body-license_server_unavailable' : 'The server {0} has disconnected from the license server.',
    'Message.body-license_server_unreachable' : 'A license for {0} could not be checked-out because the license server could not be reached at the given address and port. Please check the connection details, and verify that the license server is running.',
    'Message.body-metadata_lun_broken' : 'Pool \'{0}\' is unable to access the HA metadata disk. Until access is restored changes to the pool metadata may be lost in the event of an HA failover.',
    'Message.body-metadata_lun_healthy' : 'Pool \'{0}\' successfully accessed the HA metadata disk after a previous failure and can perform a successful recovery in the event of an HA failover.',
    'Message.body-multipath_periodic_alert' : 'Server \'{0}\' has experienced a change in multipath status. Currently {1} out of {2} paths are active. See the XenCenter logs for the full details.',
    'Message.body-multipath_periodic_alert_healthy' : 'Servers in pool \'{0}\' have experienced a change in multipath status. Currently all paths are active. See the XenCenter logs for the full details.',
    'Message.body-multipath_periodic_alert_healthy_standalone' : 'Server \'{0}\' has experienced a change in multipath status. Currently all paths are active. See the XenCenter logs for the full details.',
    'Message.body-multipath_periodic_alert_summary' : 'Servers in pool \'{0}\' have experienced a change in multipath status. Currently the following servers have inactive paths: {1}. See the XenCenter logs for the full details.',
    'Message.body-pbd_plug_failed_on_server_start' : 'A storage repository could not be attached when server \'{0}\' started.  You may be able to fix this using the \'Repair Storage\' option in the Storage menu.',
    'Message.body-pool_master_transition' : 'Server \'{0}\' is now the master of pool \'{1}\'.',
    'Message.body-vbd_qos_failed' : 'Quality of Service settings for disk \'{0}\' on virtual machine \'{1}\' could not be obeyed.',
    'Message.body-vcpu_qos_failed' : 'Quality of Service settings for VCPU \'{0}\' on virtual machine \'{1}\' could not be obeyed.',
    'Message.body-vif_qos_failed' : 'Quality of Service settings for network interface \'{0}\' on virtual machine \'{1}\' could not be obeyed.',
    'Message.body-vm_cloned' : 'Virtual machine \'{0}\' has been cloned.',
    'Message.body-vm_crashed' : 'Virtual machine \'{0}\' has crashed',
    'Message.body-vm_rebooted' : 'Virtual machine \'{0}\' has been rebooted.',
    'Message.body-vm_resumed' : 'Virtual machine \'{0}\' has been resumed.',
    'Message.body-vm_shutdown' : 'Virtual machine \'{0}\' has been shut down.',
    'Message.body-vm_started' : 'Virtual machine \'{0}\' has been started.',
    'Message.body-vm_suspended' : 'Virtual machine \'{0}\' has been suspended.',
    'Message.body-vm_uncooperative' : 'Virtual machine \'{0}\' did not reduce its memory usage when requested.',
    'Message.body-wlb_consultation_failed' : 'Pool \'{0}\' failed to retrieve placement recommendations from WLB for VM \'{1}\'.',
    'Message.body-wlb_optimization_alert' : 'WLB reports that the pool \'{0}\' is in need of optimization. The pool optimization mode is set to \'{1}\' and the severity of the alert is \'{2}\'.',
    'Message.help-alarm' : 'Help on Alarms',
    'Message.help-ha_heartbeat_approaching_timeout' : 'Help on HA',
    'Message.help-ha_host_failed' : 'Help on HA',
    'Message.help-ha_host_was_fenced' : 'Help on HA',
    'Message.help-ha_network_bonding_error' : 'Help on HA',
    'Message.help-ha_pool_drop_in_plan_exists_for' : 'Help on HA',
    'Message.help-ha_pool_overcommitted' : 'Help on HA',
    'Message.help-ha_protected_vm_restart_failed' : 'Help on HA',
    'Message.help-ha_statefile_approaching_timeout' : 'Help on HA',
    'Message.help-ha_statefile_lost' : 'Help on HA',
    'Message.help-ha_xapi_healthcheck_approaching_timeout' : 'Help on HA',
    'Message.help-host_sync_data_failed' : 'Help on HA',
    'Message.help-license_does_not_support_pooling' : 'Help on Licensing',
    'Message.help-pbd_plug_failed_on_server_start' : 'Help on Broken Storage',
    'Message.help-vbd_qos_failed' : 'Help on QoS',
    'Message.help-vcpu_qos_failed' : 'Help on QoS',
    'Message.help-vif_qos_failed' : 'Help on QoS',
    'Message.name-alarm' : 'Unrecognized alarm',
    'Message.name-extauth_in_pool_is_non_homogeneous' : 'Authentication method is not consistent across the Pool',
    'Message.name-extauth_init_in_host_failed' : 'Active Directory authorization is not available',
    'Message.name-grace_license' : 'Grace license issued.',
    'Message.name-ha_heartbeat_approaching_timeout' : 'HA heartbeat approaching timeout',
    'Message.name-ha_host_failed' : 'Server failed',
    'Message.name-ha_host_was_fenced' : 'Server recovered',
    'Message.name-ha_network_bonding_error' : 'HA network bonding error',
    'Message.name-ha_pool_drop_in_plan_exists_for' : 'Drop in HA failover tolerance',
    'Message.name-ha_pool_overcommitted' : 'Drop in HA failover tolerance',
    'Message.name-ha_protected_vm_restart_failed' : 'HA-protected VM failed to restart',
    'Message.name-ha_statefile_approaching_timeout' : 'Heartbeat SR approaching timeout',
    'Message.name-ha_statefile_lost' : 'Heartbeat SR lost',
    'Message.name-ha_xapi_healthcheck_approaching_timeout' : 'XenServer healthcheck approaching timeout',
    'Message.name-host_clock_skew_detected' : 'Server clock not synchronized',
    'Message.name-host_sync_data_failed' : 'XenServer statistics synchronization failed',
    'Message.name-license_does_not_support_pooling' : 'License does not support pooling',
    'Message.name-license_expired' : 'License Expired.',
    'Message.name-license_expires_soon' : 'License expires soon',
    'Message.name-license_not_available' : 'A license was not available.',
    'Message.name-license_server_connected' : 'License server connection successful.',
    'Message.name-license_server_unavailable' : 'Server disconnected from license server.',
    'Message.name-license_server_unreachable' : 'The license server could not be reached.',
    'Message.name-metadata_lun_broken' : 'Lost access to HA metadata disk',
    'Message.name-metadata_lun_healthy' : 'Restored access to HA metadata disk',
    'Message.name-multipath_periodic_alert' : 'Multipath Alert',
    'Message.name-pbd_plug_failed_on_server_start' : 'Failed to attach storage on server boot',
    'Message.name-pool_master_transition' : 'Pool master changed',
    'Message.name-vbd_qos_failed' : 'VM Disk QoS Failed',
    'Message.name-vcpu_qos_failed' : 'VM VCPU QoS Failed',
    'Message.name-vif_qos_failed' : 'VM Network Interface QoS Failed',
    'Message.name-vm_cloned' : 'VM Cloned',
    'Message.name-vm_crashed' : 'VM Crashed',
    'Message.name-vm_rebooted' : 'VM Rebooted',
    'Message.name-vm_resumed' : 'VM Resumed',
    'Message.name-vm_shutdown' : 'VM Shutdown',
    'Message.name-vm_started' : 'VM Started',
    'Message.name-vm_suspended' : 'VM Suspended',
    'Message.name-vm_uncooperative' : 'VM Uncooperative',
    'Message.name-wlb_consultation_failed' : 'WLB consultation has failed',
    'Message.name-wlb_optimization_alert' : 'WLB optimization alert',
    'NewVMWizard-CdMediaPage.PageName' : 'Source',
    'NewVMWizard-CdMediaPage.PageTitle' : 'Locate the operating system installation media',
    'NewVMWizard-CpuMemPage.PageName' : 'CPU & Memory',
    'NewVMWizard-CpuMemPage.PageTitle' : 'Allocate processor and memory resources',
    'NewVMWizard-FinishPage.PageName' : 'Finish',
    'NewVMWizard-FinishPage.PageTitle' : 'Ready to create the new virtual machine',
    'NewVMWizard-FirstRunPage.PageName' : 'First Run',
    'NewVMWizard-FirstRunPage.PageTitle' : 'Before you begin',
    'NewVMWizard-HomeServerPage.PageName' : 'Home Server',
    'NewVMWizard-HomeServerPage.PageTitle' : 'Select a home server',
    'NewVMWizard-InstallationMediaPage.PageName' : 'Installation Media',
    'NewVMWizard-InstallationMediaPage.PageTitle' : 'Locate the operating system installation media',
    'NewVMWizard-NamePage.PageName' : 'Name',
    'NewVMWizard-NamePage.PageTitle' : 'Name the new virtual machine',
    'NewVMWizard-NetworkMediaPage.PageName' : 'Source',
    'NewVMWizard-NetworkMediaPage.PageTitle' : 'Locate the operating system installation media',
    'NewVMWizard-NetworkingPage.PageName' : 'Networking',
    'NewVMWizard-NetworkingPage.PageTitle' : 'Configure networking on the new VM',
    'NewVMWizard-StoragePage.PageName' : 'Storage',
    'NewVMWizard-StoragePage.PageTitle' : 'Configure storage for the new VM',
    'NewVMWizard-TemplatePage.PageName' : 'Template',
    'NewVMWizard-TemplatePage.PageTitle' : 'Select a VM template',
    'Role.pool-admin.Description' : 'Pool Admins have full access to all XenServer features and settings. They can access the XenServer console and manage the roles of other users.\
 \
- No restrictions\
- Role and user management\
- Access to XenServer console',
    'Role.pool-admin.NameLabel' : 'Pool Admin',
    'Role.pool-operator.Description' : 'Pool Operators manage pool-wide resources, including setting up storage, managing patches and creating resource pools.\
 \
- Configure pool resources\
- Full access to High Availability (HA), Workload Balancing (WLB) and patch management features\
- No access to role management',
    'Role.pool-operator.NameLabel' : 'Pool Operator',
    'Role.read-only.Description' : 'With a Read Only role, the user has basic read access. They can connect to the server and view its contents, but will be unable to issue commands or alter any settings.\
 \
- Read access only',
    'Role.read-only.NameLabel' : 'Read Only',
    'Role.vm-admin.Description' : 'VM Admins can manage VMs and Templates and can access the storage necessary to complete these tasks. This role relies on XenServer to choose where to run each VM, and on templates to provide values for dynamic memory control (DMC) and Home Server settings.\
 \
- Manage VMs and Templates\
- No access to dynamic memory control features\
- No access to VM snapshot features\
- Cannot set Home Server or choose where to run workloads',
    'Role.vm-admin.NameLabel' : 'VM Admin',
    'Role.vm-operator.Description' : 'VM Operators are granted access to use the VMs within the resource pool. They can interact with VM consoles, and can start or stop VMs when there are sufficient server resources available.\
 \
- Full access to VM consoles\
- Basic VM lifecycle control\
- Cannot alter VM properties or server resources',
    'Role.vm-operator.NameLabel' : 'VM Operator',
    'Role.vm-power-admin.Description' : 'VM Power Admins have full access to VM and Template management. They can choose where to start VMs, and can use the dynamic memory control and VM snapshot features.\
 \
- Manages VMs and Templates\
- Full access to dynamic memory control features\
- Full access to VM snapshot features\
- Can set Home Server and choose where to run workloads',
    'Role.vm-power-admin.NameLabel' : 'VM Power Admin',
    'SR.name_description-ebs' : 'EBS volumes',
    'SR.name_description-ebs-host' : 'EBS volumes in Availability Zone {0}',
    'SR.name_description-local-hotplug-cd' : 'Physical DVD drives',
    'SR.name_description-local-hotplug-cd-host' : 'Physical DVD drives on {0}',
    'SR.name_description-xenserver-tools' : 'XenServer Tools ISOs',
    'SR.name_label-ebs' : 'EBS',
    'SR.name_label-ebs-host' : 'EBS in {0}',
    'SR.name_label-local-hotplug-cd' : 'DVD drives',
    'SR.name_label-local-hotplug-cd-host' : 'DVD drives on {0}',
    'SR.name_label-local-hotplug-disk' : 'Removable storage',
    'SR.name_label-local-hotplug-disk-host' : 'Removable storage on {0}',
    'SR.name_label-local-storage' : 'Local storage',
    'SR.name_label-local-storage-host' : 'Local storage on {0}',
    'SR.name_label-xenserver-tools' : 'XenServer Tools',
    'VM.TemplateDescription-CentOS 4.5' : 'Installs CentOS 4.5 from vendor media or from a network installation server.',
    'VM.TemplateDescription-CentOS 4.6' : 'Installs CentOS 4.6 from vendor media or from a network installation server.',
    'VM.TemplateDescription-CentOS 5.0' : 'Installs CentOS 5.0 32-bit from vendor media or from a network installation server.',
    'VM.TemplateDescription-CentOS 5.0 x64' : 'Installs CentOS 5.0 64-bit from vendor media or from a network installation server.',
    'VM.TemplateDescription-CentOS 5.1' : 'Installs CentOS 5.1 32-bit from vendor media or from a network installation server.',
    'VM.TemplateDescription-CentOS 5.1 x64' : 'Installs CentOS 5.1 64-bit from vendor media or from a network installation server.',
    'VM.TemplateDescription-Citrix XenApp' : 'Installs Windows Server® 2003 32-bit, optimized for installation of Citrix XenApp.',
    'VM.TemplateDescription-Citrix XenApp x64' : 'Installs Windows Server® 2003 64-bit, optimized for installation of Citrix XenApp.',
    'VM.TemplateDescription-Debian Etch 4.0' : 'Installs a ready-to-use installation of Debian Etch 4.0.',
    'VM.TemplateDescription-Debian Sarge 3.1' : 'Installs a ready-to-use installation of Debian Sarge 3.1.',
    'VM.TemplateDescription-Oracle Enterprise Linux 5.0' : 'Installs Oracle Enterprise Linux 5.0 32-bit from vendor media or from a network installation server.',
    'VM.TemplateDescription-Oracle Enterprise Linux 5.0 x64' : 'Installs Oracle Enterprise Linux 5.0 64-bit from vendor media or from a network installation server.',
    'VM.TemplateDescription-Oracle Enterprise Linux 5.1' : 'Installs Oracle Enterprise Linux 5.1 32-bit from vendor media or from a network installation server.',
    'VM.TemplateDescription-Oracle Enterprise Linux 5.1 x64' : 'Installs Oracle Enterprise Linux 5.1 64-bit from vendor media or from a network installation server.',
    'VM.TemplateDescription-Oracle Enterprise Linux 5.2' : 'Installs Oracle Enterprise Linux 5.2 32-bit from vendor media or from a network installation server.',
    'VM.TemplateDescription-Oracle Enterprise Linux 5.2 x64' : 'Installs Oracle Enterprise Linux 5.2 64-bit from vendor media or from a network installation server.',
    'VM.TemplateDescription-Other install media' : 'If the operating system you plan to use is not listed, you may be able to install it by selecting this template.  We recommend that only advanced users attempt to use this template, and you should note that our products have been tested running only the supported distributions and specific versions covered by the standard supplied templates.',
    'VM.TemplateDescription-Red Hat Enterprise Linux 4.1' : 'Installs Red Hat Enterprise Linux 4.1 from vendor media or from a network installation server.',
    'VM.TemplateDescription-Red Hat Enterprise Linux 4.4' : 'Installs Red Hat Enterprise Linux 4.4 from vendor media or from a network installation server.',
    'VM.TemplateDescription-Red Hat Enterprise Linux 4.5' : 'Installs Red Hat Enterprise Linux 4.5 from vendor media or from a network installation server.',
    'VM.TemplateDescription-Red Hat Enterprise Linux 4.6' : 'Installs Red Hat Enterprise Linux 4.6 from vendor media or from a network installation server.',
    'VM.TemplateDescription-Red Hat Enterprise Linux 5.0' : 'Installs Red Hat Enterprise Linux 5.0 32-bit from vendor media or from a network installation server.',
    'VM.TemplateDescription-Red Hat Enterprise Linux 5.0 x64' : 'Installs Red Hat Enterprise Linux 5.0 64-bit from vendor media or from a network installation server.',
    'VM.TemplateDescription-Red Hat Enterprise Linux 5.1' : 'Installs Red Hat Enterprise Linux 5.1 32-bit from vendor media or from a network installation server.',
    'VM.TemplateDescription-Red Hat Enterprise Linux 5.1 x64' : 'Installs Red Hat Enterprise Linux 5.1 64-bit from vendor media or from a network installation server.',
    'VM.TemplateDescription-Red Hat Enterprise Linux 5.2' : 'Installs Red Hat Enterprise Linux 5.2 32-bit from vendor media or from a network installation server.',
    'VM.TemplateDescription-Red Hat Enterprise Linux 5.2 x64' : 'Installs Red Hat Enterprise Linux 5.2 64-bit from vendor media or from a network installation server.',
    'VM.TemplateDescription-SUSE Linux Enterprise Server 10 SP1' : 'Installs SUSE Linux Enterprise Server 10 32-bit Service Pack 1 from vendor media or from a network installation server.',
    'VM.TemplateDescription-SUSE Linux Enterprise Server 10 SP1 x64' : 'Installs SUSE Linux Enterprise Server 10 64-bit Service Pack 1 from vendor media or from a network installation server.',
    'VM.TemplateDescription-SUSE Linux Enterprise Server 10 SP2' : 'Installs SUSE Linux Enterprise Server 10 32-bit Service Pack 2 from vendor media or from a network installation server.',
    'VM.TemplateDescription-SUSE Linux Enterprise Server 10 SP2 x64' : 'Installs SUSE Linux Enterprise Server 10 64-bit Service Pack 2 from vendor media or from a network installation server.',
    'VM.TemplateDescription-SUSE Linux Enterprise Server 9 SP4' : 'Installs SUSE Linux Enterprise Server 9 Service Pack 4 from a network installation server.',
    'VM.TemplateDescription-Windows 2000 SP4' : 'Installs Windows 2000 Server Service Pack 4. Earlier service packs are not supported.',
    'VM.TemplateDescription-Windows Server 2003' : 'Installs Windows Server® 2003 32-bit Service Pack 0, 1, or 2. The Server, Enterprise, Data Centre, and SBS editions are supported.',
    'VM.TemplateDescription-Windows Server 2003 x64' : 'Installs Windows Server® 2003 64-bit. The Server, Enterprise, Data Centre, and SBS Editions are supported.',
    'VM.TemplateDescription-Windows Server 2008' : 'Installs Windows Server® 2008 32-bit.',
    'VM.TemplateDescription-Windows Server 2008 x64' : 'Installs Windows Server® 2008 64-bit.',
    'VM.TemplateDescription-Windows Vista' : 'Installs Windows Vista™ 32-bit Enterprise Edition.',
    'VM.TemplateDescription-Windows XP SP2' : 'Installs Windows XP Service Pack 2. Earlier service packs are not supported.',
    'VM.TemplateDescription-Windows XP SP3' : 'Installs Windows XP Service Pack 3. Service Pack 2 is also supported, though an immediate upgrade is recommended. Earlier service packs are not supported.',
  }
