(*
 * Copyright (c) 2012-2014 Anil Madhavapeddy <anil@recoil.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *)

val build_sockaddr : string -> string -> Lwt_unix.sockaddr Lwt.t

module Tcp_client : sig
  open Lwt_io

  val connect : Lwt_unix.sockaddr -> (input channel * output channel) Lwt.t

  val close : input channel * output channel -> unit Lwt.t
end

module Tcp_server : sig
  open Lwt_io

  val init_socket : Lwt_unix.sockaddr -> Lwt_unix.file_descr

  val init :
    sockaddr:Lwt_unix.sockaddr ->
    ?timeout:int ->
    (input channel -> output channel -> unit Lwt.t) ->
    unit Lwt.t

  val close : input channel * output channel -> unit Lwt.t
end

