#!/bin/sh
mkdir -p ${DESTDIR}//usr/sbin

install -D _build/libvirt/xenops_libvirt_main.native     ${DESTDIR}//usr/sbin/xenopsd-libvirt
install -D _build/simulator/xenops_simulator_main.native ${DESTDIR}//usr/sbin/xenopsd-simulator
install -D _build/xc/xenops_xc_main.native               ${DESTDIR}//usr/sbin/xenopsd-xc
install -D _build/xl/xenops_xl_main.native               ${DESTDIR}//usr/sbin/xenopsd-xenlight
install -D -m 0755 xenopsd-xenlight-init ${DESTDIR}//etc/init.d/xenopsd-xenlight
mkdir -p ${DESTDIR}//usr/lib/xenopsd
install -D scripts/vif ${DESTDIR}//usr/lib/xenopsd/vif
install -D scripts/vif-real ${DESTDIR}//usr/lib/xenopsd/vif-real
install -D scripts/block ${DESTDIR}//usr/lib/xenopsd/block
install -D scripts/qemu-dm-wrapper ${DESTDIR}//usr/lib/xenopsd/qemu-dm-wrapper
install -D xenopsd-vncterm-wrapper ${DESTDIR}//usr/lib/xenopsd/vncterm-wrapper
install -D scripts/qemu-vif-script ${DESTDIR}//usr/lib/xenopsd/qemu-vif-script
install -D scripts/setup-vif-rules ${DESTDIR}//usr/lib/xenopsd/setup-vif-rules
install -D scripts/common.py ${DESTDIR}//usr/lib/xenopsd/common.py
install -D scripts/network.conf ${DESTDIR}//usr/lib/xenopsd/network.conf

mkdir -p ${DESTDIR}/etc/init.d
install -m 0755 xenopsd-libvirt-init ${DESTDIR}//etc/init.d/xenopsd-libvirt
install -m 0755 xenopsd-xc-init ${DESTDIR}//etc/init.d/xenopsd-xc
install -m 0755 xenopsd-simulator-init ${DESTDIR}//etc/init.d/xenopsd-simulator

mkdir -p ${DESTDIR}/etc/xapi
chmod 755 make-xsc-xenopsd.conf 
LIBEXECDIR=/usr/lib/xenopsd ETCDIR=/etc/xapi SCRIPTSDIR=/usr/lib/xenopsd DESTDIR=${DESTDIR} ./make-xsc-xenopsd.conf > xenopsd-conf
install -m 0644 xenopsd-conf ${DESTDIR}/etc/xenopsd.conf
install -m 0644 xenopsd-network-conf ${DESTDIR}/etc/xapi/network.conf


